/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.report;

import java.util.Date;
import java.util.List;

import org.springframework.orm.hibernate3.HibernateTemplate;

import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;


import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportEEDWeeklyReportType;
import gov.va.med.esr.common.report.data.CommonCriteria;

/**
 * @author DNS   LEV
 *
 */
public class WeeklyReportTest extends AbstractReportTest {

   /**
    * @param testName
    */
   public WeeklyReportTest(String testName) {
      super(testName);
      // Uncomment this line if you want the test report
      // to be persisted in DEV database
      // this.setDefaultRollback( false );
   }
   
   public void testAACAutoUpdates() throws Exception {
      
      // create start and end date
      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
      Date endTime = DateUtils.createCalendar( 2006, 12, 1 ).getTime();
      
      // Create report parameter set
      ReportParameterSet parameterSet = new ReportParameterSet();
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
      parameterSet.setFromDate( startTime );
      parameterSet.setToDate( endTime );
      
      ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.AAC_AUTO_UDPATE.getCode()) );
      parameterSet.addReportEEDWeeklyReportType( type );
      
      // Create a report setup
      ReportSetup setup = new ReportSetup();
      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_8.getCode() ) );
      setup.setParameterSet( parameterSet );
      setup.setSetupUser( this.getESRUser() );

      this.generateReport( this.getESRUser(), setup );
   }
   
   public void testEnrollmentLetters() throws Exception {
      
      // create start and end date
      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
      Date endTime = DateUtils.createCalendar( 2006, 12, 1 ).getTime();
      
      // Create report parameter set
      ReportParameterSet parameterSet = new ReportParameterSet();
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
      parameterSet.setFromDate( startTime );
      parameterSet.setToDate( endTime );
      
      ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.AAC_ENROLLMENT_LETTERS.getCode()) );
      parameterSet.addReportEEDWeeklyReportType( type );
      
      // Create a report setup
      ReportSetup setup = new ReportSetup();
      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_8.getCode() ) );
      setup.setParameterSet( parameterSet );
      setup.setSetupUser( this.getESRUser() );

      this.generateReport( this.getESRUser(), setup );
   }
   public void testOtherUpdates() throws Exception {
      
      // create start and end date
      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
      Date endTime = DateUtils.createCalendar( 2006, 12, 1 ).getTime();
      
      // Create report parameter set
      ReportParameterSet parameterSet = new ReportParameterSet();
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
      parameterSet.setFromDate( startTime );
      parameterSet.setToDate( endTime );
      
      ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.OTHER_UPDATES.getCode()) );
      parameterSet.addReportEEDWeeklyReportType( type );
      
      // Create a report setup
      ReportSetup setup = new ReportSetup();
      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_8.getCode() ) );
      setup.setParameterSet( parameterSet );
      setup.setSetupUser( this.getESRUser() );

      this.generateReport( this.getESRUser(), setup );
   }
   
   public void testEnrollmentUpdates() throws Exception {
      
      // create start and end date
      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
      Date endTime = DateUtils.createCalendar( 2006, 12, 1 ).getTime();
      
      // Create report parameter set
      ReportParameterSet parameterSet = new ReportParameterSet();
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
      parameterSet.setFromDate( startTime );
      parameterSet.setToDate( endTime );
      
      ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.ENROLLMENT_UPDATES.getCode()) );
      parameterSet.addReportEEDWeeklyReportType( type );
      
      // Create a report setup
      ReportSetup setup = new ReportSetup();
      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_8.getCode() ) );
      setup.setParameterSet( parameterSet );
      setup.setSetupUser( this.getESRUser() );

      this.generateReport( this.getESRUser(), setup );
   }
   
   public void testAddressStatistics() throws Exception {
      
      // create start and end date
      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
      Date endTime = DateUtils.createCalendar( 2006, 12, 1 ).getTime();
      
      // Create report parameter set
      ReportParameterSet parameterSet = new ReportParameterSet();
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
      parameterSet.setFromDate( startTime );
      parameterSet.setToDate( endTime );
      
      ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.AAC_ADDRESS_STATS.getCode()) );
      parameterSet.addReportEEDWeeklyReportType( type );
      
      // Create a report setup
      ReportSetup setup = new ReportSetup();
      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_8.getCode() ) );
      setup.setParameterSet( parameterSet );
      setup.setSetupUser( this.getESRUser() );

      this.generateReport( this.getESRUser(), setup );
   }
   
   public void testAll() throws Exception {
      
      // create start and end date
      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
      Date endTime = DateUtils.createCalendar( 2006, 12, 1 ).getTime();
      
      // Create report parameter set
      ReportParameterSet parameterSet = new ReportParameterSet();
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
      parameterSet.setFromDate( startTime );
      parameterSet.setToDate( endTime );
      
      // Add OTHER_UPDATES report
      ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.OTHER_UPDATES.getCode()) );
      parameterSet.addReportEEDWeeklyReportType( type );
      
      // Add AAC_ADDRESS_STATS report
      type = new ReportEEDWeeklyReportType();
      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.AAC_ADDRESS_STATS.getCode()) );
      parameterSet.addReportEEDWeeklyReportType( type );
      
      // Add AAC_AUTO_UDPATE report
      type = new ReportEEDWeeklyReportType();
      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.AAC_AUTO_UDPATE.getCode()) );
      parameterSet.addReportEEDWeeklyReportType( type );
      
      // Create a report setup
      ReportSetup setup = new ReportSetup();
      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_8.getCode() ) );
      setup.setParameterSet( parameterSet );
      setup.setSetupUser( this.getESRUser() );

      this.generateReport( this.getESRUser(), setup );
   }
   
   
   
   public void testEnrollmentEligibilityQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE
	                                           };
	      
	      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
	      Date endTime = DateUtils.createCalendar( 2007, 1, 1 ).getTime();	     
	      Object[] paramValues = new Object[]{ startTime, endTime };

	      List results = tpl.findByNamedQueryAndNamedParam( "EligibilityUpdates",
	                                                        paramNames,
	                                                        paramValues );
	      logger.info( "Results returned: " + results );
	      assertNotNull( results );
	      assertFalse( results.isEmpty() );   
	   }
   
   public void testEligibilityUpdates() throws Exception {
	      
	      // create start and end date
	      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
	      Date endTime = DateUtils.createCalendar( 2006, 12, 1 ).getTime();
	      
	      // Create report parameter set
	      ReportParameterSet parameterSet = new ReportParameterSet();
	      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
	      parameterSet.setFromDate( startTime );
	      parameterSet.setToDate( endTime );
	      
	      ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
	      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.ELIGIBILITY_UPDATES.getCode()) );
	      parameterSet.addReportEEDWeeklyReportType( type );
	      
	      // Create a report setup
	      ReportSetup setup = new ReportSetup();
	      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_8.getCode() ) );
	      setup.setParameterSet( parameterSet );
	      setup.setSetupUser( this.getESRUser() );

	      this.generateReport( this.getESRUser(), setup );
	   }
   
   public void testEnrollmentLettersQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE,
	                                          "formName" };
	      
	      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
	      Date endTime = DateUtils.createCalendar( 2006, 1, 1 ).getTime();
	      String formName = ComLetterTemplateType.FORM_NUMBER_600C.getCode();
	      Object[] paramValues = new Object[]{ startTime, endTime, formName };

	      List results = tpl.findByNamedQueryAndNamedParam( "AACEnrollmentLetters",
	                                                        paramNames,
	                                                        paramValues );
	      logger.info( "Results returned: " + results );
	      assertNotNull( results );
	      assertFalse( results.isEmpty() );   
	   }
	   
	   public void testPHStatsQuery() throws Exception {
		      
		      HibernateTemplate tpl = this.getHibernateTemplate();
		      
		      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
		                                          CommonCriteria.END_DATE
		                                           };
		      
		      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
		      Date endTime = DateUtils.createCalendar( 2007, 1, 1 ).getTime();	     
		      Object[] paramValues = new Object[]{ startTime, endTime };

		      List results = tpl.findByNamedQueryAndNamedParam( "PHStats",
		                                                        paramNames,
		                                                        paramValues );
		      logger.info( "Results returned: " + results );
		      assertNotNull( results );
		      assertFalse( results.isEmpty() );   
		   }
	   
	   public void testPHStats() throws Exception {
		      
		      // create start and end date
		      Date startTime = DateUtils.createCalendar( 2001, 1, 1 ).getTime();
		      Date endTime = DateUtils.createCalendar( 2006, 12, 1 ).getTime();
		      
		      // Create report parameter set
		      ReportParameterSet parameterSet = new ReportParameterSet();
		      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
		      parameterSet.setFromDate( startTime );
		      parameterSet.setToDate( endTime );
		      
		      ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
		      type.setReportEEDWeeklyType( this.getLookupService().getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.PH_STATS.getCode()) );
		      parameterSet.addReportEEDWeeklyReportType( type );
		      
		      // Create a report setup
		      ReportSetup setup = new ReportSetup();
		      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_8.getCode() ) );
		      setup.setParameterSet( parameterSet );
		      setup.setSetupUser( this.getESRUser() );

		      this.generateReport( this.getESRUser(), setup );
		   }

}
