/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.report.ReportExportedType;

// ESR classes
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * Junit for all Undeliverable Mail reports.
 * 
 * @author Muddaiah Ranga
 */
public class UndeliverableMailReportTest extends AbstractReportTest {

	private Date startTime = DateUtils.getFiscalYearFirstQuarter( 2005, true ).getTime(); 
	private Date endTime =  DateUtils.getFiscalYearFirstQuarter( 2005, false ).getTime();
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public UndeliverableMailReportTest(String testName) {
		super(testName);
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryView() throws Exception {
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_BOS_1.getCode()  ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
		parameterSet.setDivision( this.getReportDevision( ReportDivision.ENR.getCode() ) );
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);
		
		this.getStandardReportService().generateReport( this.getESRUser(), setup );
	}
	
	/** Test query for a detail report
	 * @throws Exception
	 */
	public void testDetailView() throws Exception {
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_BOS_1.getCode()  ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
		parameterSet.setDivision( this.getReportDevision( ReportDivision.ENR.getCode() ) );
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);
		
		this.getStandardReportService().generateReport( this.getESRUser(), setup );
	}
}