/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.io.BufferedInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

// Library classes
import org.springframework.core.io.ClassPathResource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;

// Framework classes
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.fw.report.jasperreport.data.JasperReportData;
import gov.va.med.fw.report.ReportService;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes

/**
 * 
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author DNS   LEV
 */
public class TotalVetsByEnrollmentStatusReportTest extends AbstractReportTest {

	private static final String FILE_ID = "EED1-";
	private static final String TEST_DATA_FILE = "totalvetsbyenrollmentstatus.xml";
	private static final String SUMMARY_REPORT_NAME = "totalVetsByEnrollmentStatusReport.Summary";
	private static final String DETAIL_REPORT_NAME = "totalVetsByEnrollmentStatusReport.Detail";
	
	private Date startTime = DateUtils.getFiscalYearFirstQuarter( 2005, true ).getTime(); 
	private Date endTime =  DateUtils.getFiscalYearFirstQuarter( 2005, false ).getTime();
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public TotalVetsByEnrollmentStatusReportTest(String testName) {
		super(testName);
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryTemplateWithNoVISNAndSite() throws Exception {
		/*
		ReportService service = this.getReportService();
		ClassPathResource resource = new ClassPathResource(TEST_DATA_FILE);
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		
		// generate in PDF format
		String name = SUMMARY_REPORT_NAME;
		String output = ".//jasper-reports//" +  FILE_ID + name + ".Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, CommonCriteria.SUMMARY_REPORT );
		service.generateReport( config, data );
		
		// generate in CSV format
		output = ".//jasper-reports//" +  FILE_ID + name + ".Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, CommonCriteria.SUMMARY_REPORT );
		service.generateReport( config, data );
		*/
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryTemplateWithVISN() throws Exception {
		/*
		ReportService service = this.getReportService();
		ClassPathResource resource = new ClassPathResource(TEST_DATA_FILE);
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISN/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		
		// generate in PDF format
		String name = SUMMARY_REPORT_NAME;
		String output = ".//jasper-reports//" +  FILE_ID + name + ".VISN.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN" );
		service.generateReport( config, data );

		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISN/Veteran"); 
		data = new JasperReportData( dataSource );

		output = ".//jasper-reports//" +  FILE_ID + name + ".WithStatus.VISN.Template.pdf";
		config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		
		// generate in CSV format
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISN/Veteran"); 
		data = new JasperReportData( dataSource );

		output = ".//jasper-reports//" +  FILE_ID + name + ".VISN.Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN" );
		service.generateReport( config, data );
		
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISN/Veteran"); 
		data = new JasperReportData( dataSource );

		output = ".//jasper-reports//" +  FILE_ID + name + ".WithStatus.VISN.Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		*/
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryTemplateWithSite() throws Exception {
		/*
		ReportService service = this.getReportService();
		ClassPathResource resource = new ClassPathResource(TEST_DATA_FILE);
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/Site/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		
		// generate in PDF format
		String name = SUMMARY_REPORT_NAME;
		String output = ".//jasper-reports//" +  FILE_ID + name + ".Site.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By Site" );
		service.generateReport( config, data );
		
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/Site/Veteran"); 
		data = new JasperReportData( dataSource );
		
		output = ".//jasper-reports//" +  FILE_ID + name + ".WithStatus.Site.Template.pdf";
		config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By Site" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		
		// generate in CSV format
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/Site/Veteran"); 
		data = new JasperReportData( dataSource );
		
		output = ".//jasper-reports//" +  FILE_ID + name + ".Site.Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By Site" );
		service.generateReport( config, data );
		
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/Site/Veteran"); 
		data = new JasperReportData( dataSource );
		
		output = ".//jasper-reports//" +  FILE_ID + name + ".WithStatus.Site.Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By Site" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		*/
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryTemplateWithVISNAndSite() throws Exception {
		/*
		ReportService service = this.getReportService();
		ClassPathResource resource = new ClassPathResource(TEST_DATA_FILE);
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISNAndSite/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		
		// generate in PDF format
		String name = SUMMARY_REPORT_NAME;
		String output = ".//jasper-reports//" +  FILE_ID + name + ".VISN.Site.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN - Site" );
		service.generateReport( config, data );
		
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISNAndSite/Veteran"); 
		data = new JasperReportData( dataSource );
		
		output = ".//jasper-reports//" +  FILE_ID + name + ".WithStatus.VISN.Site.Template.pdf";
		config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN - Site" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		
		// generate in CSV format
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISNAndSite/Veteran"); 
		data = new JasperReportData( dataSource );
		
		output = ".//jasper-reports//" +  FILE_ID + name + ".VISN.Site.Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN - Site" );
		service.generateReport( config, data );
		
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISNAndSite/Veteran"); 
		data = new JasperReportData( dataSource );
		
		output = ".//jasper-reports//" +  FILE_ID + name + ".WithStatus.VISN.Site.Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN - Site" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		*/
	}
	
	/** Test query for a detail report
	 * @throws Exception
	 */
	public void testDetailTemplateWithNoVISNAndSite() throws Exception {
		/*	
		ReportService service = this.getReportService();
		ClassPathResource resource = new ClassPathResource(TEST_DATA_FILE);
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/Status/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		
		// generate in PDF format
		String name = DETAIL_REPORT_NAME;
		String output = ".//jasper-reports//" +  FILE_ID + name + ".Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, CommonCriteria.SUMMARY_REPORT );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		
		// generate in CSV format
		output = ".//jasper-reports//" +  FILE_ID + name + ".Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, CommonCriteria.SUMMARY_REPORT );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		*/
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testDetailTemplateWithVISN() throws Exception {
		/*
		ReportService service = this.getReportService();
		ClassPathResource resource = new ClassPathResource(TEST_DATA_FILE);
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/VISN/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		
		// generate in PDF format
		String name = DETAIL_REPORT_NAME;
		String output = ".//jasper-reports//" +  FILE_ID + name + ".VISN.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Detail Report By VISN" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );

		// generate in CSV format
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/VISN/Veteran"); 
		data = new JasperReportData( dataSource );

		output = ".//jasper-reports//" +  FILE_ID + name + ".VISN.Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Detail Report By VISN" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		*/
	}
	
	
	/** Test query for a detail report
	 * @throws Exception
	 */
	public void testDetailTemplateWithVISNAndSite() throws Exception {
	/*	
		ReportService service = this.getReportService();
		ClassPathResource resource = new ClassPathResource(TEST_DATA_FILE);
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/VISNAndSite/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		
		// generate in PDF format
		String name = DETAIL_REPORT_NAME;
		String output = ".//jasper-reports//" +  FILE_ID + name + ".VISN.Site.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, output, ReportExportedType.PDF );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Detail Report By VISN - Site" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		
		// generate in CSV format
		resource = new ClassPathResource(TEST_DATA_FILE);
		stream = new BufferedInputStream( resource.getInputStream() );
		dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/VISNAndSite/Veteran"); 
		data = new JasperReportData( dataSource );
		
		output = ".//jasper-reports//" +  FILE_ID + name + ".VISN.Site.Template.csv";
		config = this.getReportConfiguration( name, output, ReportExportedType.CSV );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Detail Report By VISN - Site" );
		config.getResourceMapping().put( "DISPLAY_STATUS", Boolean.TRUE );
		service.generateReport( config, data );
		*/
	}
	
	/**
	 * @param name
	 * @param output
	 * @param type
	 * @return
	 * @throws Exception
	 */
	protected ReportConfiguration getReportConfiguration( String name, String ID, ReportExportedType type ) throws Exception {
	/*	
		// Create a report configuration
		ReportConfiguration config = new ReportConfiguration( name, ID, type );
		
		// Populate a map of report parameters
		Map parameters = new HashMap();
		parameters.put( CommonCriteria.START_DATE, this.startTime );
		parameters.put( CommonCriteria.END_DATE, this.endTime );
		parameters.put( CommonCriteria.RUN_DATE, Calendar.getInstance().getTime() );
		parameters.put( CommonCriteria.REPORT_TITLE, "Cancelled/Declined Report" );
		
		// Populate a query criteria
		Map criteria = new HashMap();
		criteria.put( CommonCriteria.START_DATE, this.startTime );
		criteria.put( CommonCriteria.END_DATE, this.endTime );
		
		config.setQueryCriteria( new CommonCriteria( criteria ) );
		config.setResourceMapping( parameters );
		return config;
*/
		return null;
	}
}