/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

// Library classes
import org.springframework.orm.hibernate3.HibernateTemplate;

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.FacilityDisplayByReportNameResolver;
import gov.va.med.esr.common.model.report.ReportEnrollmentPriorityGroup;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author DNS   KULLAV
 */
public class TotalEnrollmentStatusReportTest extends AbstractReportTest {

	/**
	 * A default constructor
	 * @param testName
	 */
	public TotalEnrollmentStatusReportTest(String testName) {
		super(testName);
      // Uncomment this line if you want the test report
      // to be persisted in DEV database
      // this.setDefaultRollback( false );
	}
	
   public void testTotalEnrollmentStatusNationwideQuery() throws Exception {
      
      HibernateTemplate tpl = this.getHibernateTemplate();
      
      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
                                          CommonCriteria.END_DATE,
                                          CommonCriteria.ALL_GROUPS,
                                          CommonCriteria.GROUP_PRIORITIES,
                                          CommonCriteria.ALL_STATUSES,
                                          CommonCriteria.ENROLLMENT_STATUSES,
                                          CommonCriteria.ALL_SUB_GROUPS,
                                          CommonCriteria.SUB_GROUP_PRIORITIES};
     
      List list=new ArrayList();
      list.add("");
      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list
                                            };
      

      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status_nationwide.summary",
                                                        paramNames,
                                                        paramValues
                                                        );
      assertNotNull( results );
      
      for( Iterator i=results.iterator(); i.hasNext();  ) {
         Object row = i.next();
         if( row instanceof Object[] ) {
            Object[] elements = (Object[])row;
            for( int pos=0; pos<elements.length; pos++ ) {
               logger.info( "Element['" + pos + "]: " + elements[pos]);
            }
         }
         else if( row instanceof Map ) {
            Map data = (Map)row;
            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
               Map.Entry entry = (Map.Entry)iter.next();
               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
            }
         }
         else if( row instanceof List ) {
            List data = (List)row;
            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
               logger.info( "Value: " + iter.next() );
            }
         }
         else {
            logger.info( "element: " + row );
         }
      }
   }
  
	public void testTotalEnrollmentStatusByVISNVAMCSiteQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE,
	                                          CommonCriteria.ALL_FACILITIES,
	                                          CommonCriteria.FACILITIES,
	                                          CommonCriteria.ALL_GROUPS,
	                                          CommonCriteria.GROUP_PRIORITIES,
	                                          CommonCriteria.ALL_STATUSES,
	                                          CommonCriteria.ENROLLMENT_STATUSES,
	                                          CommonCriteria.ALL_SUB_GROUPS,
	                                          CommonCriteria.SUB_GROUP_PRIORITIES};
	     
	      List list=new ArrayList();
	      list.add("");
	      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
	                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list
	                                            };

	      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status.visn.vamc.site.summary",
	                                                        paramNames,
	                                                        paramValues );
	      assertNotNull( results );
	      
	      for( Iterator i=results.iterator(); i.hasNext();  ) {
	         Object row = i.next();
	         if( row instanceof Object[] ) {
	            Object[] elements = (Object[])row;
	            for( int pos=0; pos<elements.length; pos++ ) {
	               logger.info( "Element['" + pos + "]: " + elements[pos]);
	            }
	         }
	         else if( row instanceof Map ) {
	            Map data = (Map)row;
	            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
	               Map.Entry entry = (Map.Entry)iter.next();
	               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
	            }
	         }
	         else if( row instanceof List ) {
	            List data = (List)row;
	            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
	               logger.info( "Value: " + iter.next() );
	            }
	         }
	         else {
	            logger.info( "element: " + row );
	         }
	      }
	   }
	
	public void testTotalEnrollmentStatusByVISNQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE,
	                                          CommonCriteria.ALL_FACILITIES,
	                                          CommonCriteria.FACILITIES,
	                                          CommonCriteria.ALL_GROUPS,
	                                          CommonCriteria.GROUP_PRIORITIES,
	                                          CommonCriteria.ALL_STATUSES,
	                                          CommonCriteria.ENROLLMENT_STATUSES,
	                                          CommonCriteria.ALL_SUB_GROUPS,
	                                          CommonCriteria.SUB_GROUP_PRIORITIES};
	     
	      List list=new ArrayList();
	      list.add("");
	      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
	                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list
	                                            };

	      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status.visn.summary",
	                                                        paramNames,
	                                                        paramValues );
	      assertNotNull( results );
	      
	      for( Iterator i=results.iterator(); i.hasNext();  ) {
	         Object row = i.next();
	         if( row instanceof Object[] ) {
	            Object[] elements = (Object[])row;
	            for( int pos=0; pos<elements.length; pos++ ) {
	               logger.info( "Element['" + pos + "]: " + elements[pos]);
	            }
	         }
	         else if( row instanceof Map ) {
	            Map data = (Map)row;
	            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
	               Map.Entry entry = (Map.Entry)iter.next();
	               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
	            }
	         }
	         else if( row instanceof List ) {
	            List data = (List)row;
	            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
	               logger.info( "Value: " + iter.next() );
	            }
	         }
	         else {
	            logger.info( "element: " + row );
	         }
	      }
	   }
	
	public void testTotalEnrollmentStatusByVISNSiteQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE,
	                                          CommonCriteria.ALL_FACILITIES,
	                                          CommonCriteria.FACILITIES,
	                                          CommonCriteria.ALL_GROUPS,
	                                          CommonCriteria.GROUP_PRIORITIES,
	                                          CommonCriteria.ALL_STATUSES,
	                                          CommonCriteria.ENROLLMENT_STATUSES,
	                                          CommonCriteria.ALL_SUB_GROUPS,
	                                          CommonCriteria.SUB_GROUP_PRIORITIES};
	     
	      List list=new ArrayList();
	      list.add("");
	      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
	                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list
	                                            };

	      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status.visn.site.summary",
	                                                        paramNames,
	                                                        paramValues );
	      assertNotNull( results );
	      
	      for( Iterator i=results.iterator(); i.hasNext();  ) {
	         Object row = i.next();
	         if( row instanceof Object[] ) {
	            Object[] elements = (Object[])row;
	            for( int pos=0; pos<elements.length; pos++ ) {
	               logger.info( "Element['" + pos + "]: " + elements[pos]);
	            }
	         }
	         else if( row instanceof Map ) {
	            Map data = (Map)row;
	            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
	               Map.Entry entry = (Map.Entry)iter.next();
	               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
	            }
	         }
	         else if( row instanceof List ) {
	            List data = (List)row;
	            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
	               logger.info( "Value: " + iter.next() );
	            }
	         }
	         else {
	            logger.info( "element: " + row );
	         }
	      }
	   }

	   public void testTotalEnrollmentStatusByVISNVAMCQuery() throws Exception {
		      
		      HibernateTemplate tpl = this.getHibernateTemplate();
		      
		      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
		                                          CommonCriteria.END_DATE,
		                                          CommonCriteria.ALL_FACILITIES,
		                                          CommonCriteria.FACILITIES,
		                                          CommonCriteria.ALL_GROUPS,
		                                          CommonCriteria.GROUP_PRIORITIES,
		                                          CommonCriteria.ALL_STATUSES,
		                                          CommonCriteria.ENROLLMENT_STATUSES,
		                                          CommonCriteria.ALL_SUB_GROUPS,
		                                          CommonCriteria.SUB_GROUP_PRIORITIES};
		     
		      List list=new ArrayList();
		      list.add("");
		      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
		                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
		                                           "ALL",
		                                           list,
		                                           "ALL",
		                                           list,
		                                           "ALL",
		                                           list,
		                                           "ALL",
		                                           list
		                                            };

		      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status.visn.vamc.summary",
		                                                        paramNames,
		                                                        paramValues );
		      assertNotNull( results );
		      
		      for( Iterator i=results.iterator(); i.hasNext();  ) {
		         Object row = i.next();
		         if( row instanceof Object[] ) {
		            Object[] elements = (Object[])row;
		            for( int pos=0; pos<elements.length; pos++ ) {
		               logger.info( "Element['" + pos + "]: " + elements[pos]);
		            }
		         }
		         else if( row instanceof Map ) {
		            Map data = (Map)row;
		            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
		               Map.Entry entry = (Map.Entry)iter.next();
		               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
		            }
		         }
		         else if( row instanceof List ) {
		            List data = (List)row;
		            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
		               logger.info( "Value: " + iter.next() );
		            }
		         }
		         else {
		            logger.info( "element: " + row );
		         }
		      }
		   }

		   public void testTotalEnrollmentStatusByVAMCQuery() throws Exception {
			      
			      HibernateTemplate tpl = this.getHibernateTemplate();
			      
			      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
			                                          CommonCriteria.END_DATE,
			                                          CommonCriteria.ALL_FACILITIES,
			                                          CommonCriteria.FACILITIES,
			                                          CommonCriteria.ALL_GROUPS,
			                                          CommonCriteria.GROUP_PRIORITIES,
			                                          CommonCriteria.ALL_STATUSES,
			                                          CommonCriteria.ENROLLMENT_STATUSES,
			                                          CommonCriteria.ALL_SUB_GROUPS,
			                                          CommonCriteria.SUB_GROUP_PRIORITIES};
			     
			      List list=new ArrayList();
			      list.add("");
			      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
			                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
			                                           "ALL",
			                                           list,
			                                           "ALL",
			                                           list,
			                                           "ALL",
			                                           list,
			                                           "ALL",
			                                           list
			                                            };

			      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status.vamc.summary",
			                                                        paramNames,
			                                                        paramValues );
			      assertNotNull( results );
			      
			      for( Iterator i=results.iterator(); i.hasNext();  ) {
			         Object row = i.next();
			         if( row instanceof Object[] ) {
			            Object[] elements = (Object[])row;
			            for( int pos=0; pos<elements.length; pos++ ) {
			               logger.info( "Element['" + pos + "]: " + elements[pos]);
			            }
			         }
			         else if( row instanceof Map ) {
			            Map data = (Map)row;
			            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
			               Map.Entry entry = (Map.Entry)iter.next();
			               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
			            }
			         }
			         else if( row instanceof List ) {
			            List data = (List)row;
			            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
			               logger.info( "Value: " + iter.next() );
			            }
			         }
			         else {
			            logger.info( "element: " + row );
			         }
			      }
			   }

			   public void testTotalEnrollmentStatusByVAMCSiteQuery() throws Exception {
				      
				      HibernateTemplate tpl = this.getHibernateTemplate();
				      
				      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
				                                          CommonCriteria.END_DATE,
				                                          CommonCriteria.ALL_FACILITIES,
				                                          CommonCriteria.FACILITIES,
				                                          CommonCriteria.ALL_GROUPS,
				                                          CommonCriteria.GROUP_PRIORITIES,
				                                          CommonCriteria.ALL_STATUSES,
				                                          CommonCriteria.ENROLLMENT_STATUSES,
				                                          CommonCriteria.ALL_SUB_GROUPS,
				                                          CommonCriteria.SUB_GROUP_PRIORITIES};
				     
				      List list=new ArrayList();
				      list.add("");
				      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
				                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
				                                           "ALL",
				                                           list,
				                                           "ALL",
				                                           list,
				                                           "ALL",
				                                           list,
				                                           "ALL",
				                                           list
				                                            };

				      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status.vamc.site.summary",
				                                                        paramNames,
				                                                        paramValues );
				      assertNotNull( results );
				      
				      for( Iterator i=results.iterator(); i.hasNext();  ) {
				         Object row = i.next();
				         if( row instanceof Object[] ) {
				            Object[] elements = (Object[])row;
				            for( int pos=0; pos<elements.length; pos++ ) {
				               logger.info( "Element['" + pos + "]: " + elements[pos]);
				            }
				         }
				         else if( row instanceof Map ) {
				            Map data = (Map)row;
				            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
				               Map.Entry entry = (Map.Entry)iter.next();
				               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
				            }
				         }
				         else if( row instanceof List ) {
				            List data = (List)row;
				            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
				               logger.info( "Value: " + iter.next() );
				            }
				         }
				         else {
				            logger.info( "element: " + row );
				         }
				      }
				   }

				   public void testTotalEnrollmentStatusBySiteQuery() throws Exception {
					      
					      HibernateTemplate tpl = this.getHibernateTemplate();
					      
					      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
					                                          CommonCriteria.END_DATE,
					                                          CommonCriteria.ALL_FACILITIES,
					                                          CommonCriteria.FACILITIES,
					                                          CommonCriteria.ALL_GROUPS,
					                                          CommonCriteria.GROUP_PRIORITIES,
					                                          CommonCriteria.ALL_STATUSES,
					                                          CommonCriteria.ENROLLMENT_STATUSES,
					                                          CommonCriteria.ALL_SUB_GROUPS,
					                                          CommonCriteria.SUB_GROUP_PRIORITIES};
					     
					      List list=new ArrayList();
					      list.add("");
					      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
					                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
					                                           "ALL",
					                                           list,
					                                           "ALL",
					                                           list,
					                                           "ALL",
					                                           list,
					                                           "ALL",
					                                           list
					                                            };

					      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status.site.summary",
					                                                        paramNames,
					                                                        paramValues );
					      assertNotNull( results );
					      
					      for( Iterator i=results.iterator(); i.hasNext();  ) {
					         Object row = i.next();
					         if( row instanceof Object[] ) {
					            Object[] elements = (Object[])row;
					            for( int pos=0; pos<elements.length; pos++ ) {
					               logger.info( "Element['" + pos + "]: " + elements[pos]);
					            }
					         }
					         else if( row instanceof Map ) {
					            Map data = (Map)row;
					            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
					               Map.Entry entry = (Map.Entry)iter.next();
					               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
					            }
					         }
					         else if( row instanceof List ) {
					            List data = (List)row;
					            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
					               logger.info( "Value: " + iter.next() );
					            }
					         }
					         else {
					            logger.info( "element: " + row );
					         }
					      }
					   }

	/** Tests summary view in pdf
	 * @throws Exception
	 */
public void testTotalEnrollmentStatusNationwideView() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
}
	
	/** Tests summary view in pdf
	 * @throws Exception
	 */
	public void testTotalEnrollmentStatusByVISNVAMCSiteView() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		parameterSet.setFacilityDisplayBy((ReportFacilityDisplayBy)getLookupService().getByCode(ReportFacilityDisplayBy.class, ReportFacilityDisplayBy.CODE_VISN));
		
		ReportFacility facility=new ReportFacility();
		facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("528GT"));
		//parameterSet.addFacility(facility);
		facility=new ReportFacility();
		facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("519HC"));
		//parameterSet.addFacility(facility);
		ReportEnrollmentPriorityGroup group1=new ReportEnrollmentPriorityGroup();
		group1.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("7"));
		parameterSet.addReportEnrollmentPriorityGroup(group1);
		ReportEnrollmentPriorityGroup group2=new ReportEnrollmentPriorityGroup();
		group2.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("3"));
		parameterSet.addReportEnrollmentPriorityGroup(group2);
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}
	
public void testTotalEnrollmentStatusByVISNView() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 1995, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		parameterSet.setFacilityDisplayBy((ReportFacilityDisplayBy)getLookupService().getByCode(ReportFacilityDisplayBy.class, ReportFacilityDisplayBy.CODE_VISN));
		
		
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}
	
public void testTotalEnrollmentStatusByVISNSiteView() throws Exception {
	
	Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
	Date endTime =  DateUtils.getCurrentDate();
	
	ReportSetup setup = new ReportSetup();
	ReportParameterSet parameterSet = new ReportParameterSet();
	setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
	parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
	parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
	parameterSet.setFromDate( startTime );
	parameterSet.setToDate( endTime );
	parameterSet.setFacilityDisplayBy((ReportFacilityDisplayBy)getLookupService().getByCode(ReportFacilityDisplayBy.class, ReportFacilityDisplayBy.CODE_VISN_SITE));
	
	ReportFacility facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("528GT"));
	//parameterSet.addFacility(facility);
	facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("519HC"));
	//parameterSet.addFacility(facility);
	ReportEnrollmentPriorityGroup group1=new ReportEnrollmentPriorityGroup();
	group1.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("7"));
	//parameterSet.addReportEnrollmentPriorityGroup(group1);
	ReportEnrollmentPriorityGroup group2=new ReportEnrollmentPriorityGroup();
	group2.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("3"));
	//parameterSet.addReportEnrollmentPriorityGroup(group2);
	setup.setParameterSet(parameterSet);		
	this.generateReport( this.getESRUser(), setup );
}
public void testTotalEnrollmentStatusBySiteView() throws Exception {
	
	Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
	Date endTime =  DateUtils.getCurrentDate();
	
	ReportSetup setup = new ReportSetup();
	ReportParameterSet parameterSet = new ReportParameterSet();
	setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
	parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
	parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
	parameterSet.setFromDate( startTime );
	parameterSet.setToDate( endTime );
	parameterSet.setFacilityDisplayBy((ReportFacilityDisplayBy)getLookupService().getByCode(ReportFacilityDisplayBy.class, ReportFacilityDisplayBy.CODE_SITE));
	
	ReportFacility facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("528GT"));
	//parameterSet.addFacility(facility);
	facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("519HC"));
	//parameterSet.addFacility(facility);
	ReportEnrollmentPriorityGroup group1=new ReportEnrollmentPriorityGroup();
	group1.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("7"));
	//parameterSet.addReportEnrollmentPriorityGroup(group1);
	ReportEnrollmentPriorityGroup group2=new ReportEnrollmentPriorityGroup();
	group2.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("3"));
	//parameterSet.addReportEnrollmentPriorityGroup(group2);
	setup.setParameterSet(parameterSet);		
	this.generateReport( this.getESRUser(), setup );
}
public void testTotalEnrollmentStatusByVAMCSiteView() throws Exception {
	
	Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
	Date endTime =  DateUtils.getCurrentDate();
	
	ReportSetup setup = new ReportSetup();
	ReportParameterSet parameterSet = new ReportParameterSet();
	setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
	parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
	parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
	parameterSet.setFromDate( startTime );
	parameterSet.setToDate( endTime );
	parameterSet.setFacilityDisplayBy((ReportFacilityDisplayBy)getLookupService().getByCode(ReportFacilityDisplayBy.class, ReportFacilityDisplayBy.CODE_SITE));
	
	ReportFacility facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("528GT"));
	//parameterSet.addFacility(facility);
	facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("519HC"));
	//parameterSet.addFacility(facility);
	ReportEnrollmentPriorityGroup group1=new ReportEnrollmentPriorityGroup();
	group1.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("7"));
	//parameterSet.addReportEnrollmentPriorityGroup(group1);
	ReportEnrollmentPriorityGroup group2=new ReportEnrollmentPriorityGroup();
	group2.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("3"));
	//parameterSet.addReportEnrollmentPriorityGroup(group2);
	setup.setParameterSet(parameterSet);		
	this.generateReport( this.getESRUser(), setup );
}
public void testTotalEnrollmentStatusByVAMCView() throws Exception {
	
	Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
	Date endTime =  DateUtils.getCurrentDate();
	
	ReportSetup setup = new ReportSetup();
	ReportParameterSet parameterSet = new ReportParameterSet();
	setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
	parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
	parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
	parameterSet.setFromDate( startTime );
	parameterSet.setToDate( endTime );
	parameterSet.setFacilityDisplayBy((ReportFacilityDisplayBy)getLookupService().getByCode(ReportFacilityDisplayBy.class, ReportFacilityDisplayBy.CODE_SITE));
	
	ReportFacility facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("528GT"));
	//parameterSet.addFacility(facility);
	facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("519HC"));
	//parameterSet.addFacility(facility);
	ReportEnrollmentPriorityGroup group1=new ReportEnrollmentPriorityGroup();
	group1.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("7"));
	//parameterSet.addReportEnrollmentPriorityGroup(group1);
	ReportEnrollmentPriorityGroup group2=new ReportEnrollmentPriorityGroup();
	group2.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("3"));
	//parameterSet.addReportEnrollmentPriorityGroup(group2);
	setup.setParameterSet(parameterSet);		
	this.generateReport( this.getESRUser(), setup );
}
public void testTotalEnrollmentStatusByVISNVAMCView() throws Exception {
	
	Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
	Date endTime =  DateUtils.getCurrentDate();
	
	ReportSetup setup = new ReportSetup();
	ReportParameterSet parameterSet = new ReportParameterSet();
	setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
	parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
	parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
	parameterSet.setFromDate( startTime );
	parameterSet.setToDate( endTime );
	parameterSet.setFacilityDisplayBy((ReportFacilityDisplayBy)getLookupService().getByCode(ReportFacilityDisplayBy.class, ReportFacilityDisplayBy.CODE_SITE));
	
	ReportFacility facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("528GT"));
	//parameterSet.addFacility(facility);
	facility=new ReportFacility();
	facility.setFacility((VAFacility)getLookupService().getVaFacilityByStationNumber("519HC"));
	//parameterSet.addFacility(facility);
	ReportEnrollmentPriorityGroup group1=new ReportEnrollmentPriorityGroup();
	group1.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("7"));
	//parameterSet.addReportEnrollmentPriorityGroup(group1);
	ReportEnrollmentPriorityGroup group2=new ReportEnrollmentPriorityGroup();
	group2.setEnrollmentPriorityGroup((EnrollmentPriorityGroup)getLookupService().getEnrollmentPriorityGroupByCode("3"));
	//parameterSet.addReportEnrollmentPriorityGroup(group2);
	setup.setParameterSet(parameterSet);		
	this.generateReport( this.getESRUser(), setup );
}

	public void testTotalEnrollmentStatusDetailQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE,
	                                          CommonCriteria.ALL_FACILITIES,
	                                          CommonCriteria.FACILITIES,
	                                          CommonCriteria.ALL_GROUPS,
	                                          CommonCriteria.GROUP_PRIORITIES,
	                                          CommonCriteria.ALL_SUB_GROUPS,
	                                          CommonCriteria.SUB_GROUP_PRIORITIES,
	                                          CommonCriteria.ALL_STATUSES,
	                                          CommonCriteria.ENROLLMENT_STATUSES,
	                                          CommonCriteria.VISNS,
	                                          CommonCriteria.VAMCS};
	     
	      List list=new ArrayList();
	      list.add("");
	      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
	                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime(),
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           "ALL",
	                                           list,
	                                           list,
	                                           list
	                                            };

	      List results = tpl.findByNamedQueryAndNamedParam( "total_vets_enrollment_status.detail",
	                                                        paramNames,
	                                                        paramValues );
	      assertNotNull( results );
	      
	      for( Iterator i=results.iterator(); i.hasNext();  ) {
	         Object row = i.next();
	         if( row instanceof Object[] ) {
	            Object[] elements = (Object[])row;
	            for( int pos=0; pos<elements.length; pos++ ) {
	               logger.info( "Element['" + pos + "]: " + elements[pos]);
	            }
	         }
	         else if( row instanceof Map ) {
	            Map data = (Map)row;
	            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
	               Map.Entry entry = (Map.Entry)iter.next();
	               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
	            }
	         }
	         else if( row instanceof List ) {
	            List data = (List)row;
	            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
	               logger.info( "Value: " + iter.next() );
	            }
	         }
	         else {
	            logger.info( "element: " + row );
	         }
	      }
	   }
public void testTotalEnrollmentStatusByVISNDetailedView() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 1995, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_EED_6.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		parameterSet.setFacilityDisplayBy((ReportFacilityDisplayBy)getLookupService().getByCode(ReportFacilityDisplayBy.class, ReportFacilityDisplayBy.CODE_VISN));
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}
}