/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.report.FileSystemReportPersister;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.util.FileUtils;

// ESR classes

/**
 * Persists a generated report stream onto a file system 
 *
 * Project: Framework</br>
 * Created on: 3:46:42 PM </br>
 *
 * @author DNS   LEV
 */
public class TestReportPersister extends FileSystemReportPersister {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -878185413664735720L;

	/**
	 * A default constructor
	 */
	public TestReportPersister() {
		super();
	}

	/**
	 * @see gov.va.med.fw.report.ReportPersister#persist(gov.va.med.fw.report.ReportConfiguration, java.io.ByteArrayOutputStream)
	 */
	public void persist( ReportConfiguration config, ByteArrayOutputStream stream ) throws ReportException {

		Validate.notNull( config, "A report configuration must not be NULL" );
		Validate.notNull( stream, "A generated report stream must not be NULL" );
		try {
			String output = ".//jasper-reports//" + config.getReportOutputName();
			OutputStream file = new BufferedOutputStream( new FileOutputStream( FileUtils.getFile( output ) ) );
			stream.writeTo( file );
			
			// Flushes generated reports to a file
			stream.flush();
			stream.close();
			
			// Close a file
			file.flush();
			file.close();
		}
		catch( IOException e ) {
			throw new ReportException( "Failed to write a report to a stream ", e );
		}
	}
}