/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.service.ReportFilter;
import gov.va.med.fw.model.EntityKey;

/**
 * Standard Report Service test cases.
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author Venky Kullampalle
 */
public class StandardReportServiceTest extends AbstractReportTest {

	/**
	 * A default constructor
	 * @param testName
	 */
	public StandardReportServiceTest(String testName) {
		super(testName);
        setDefaultRollback(false);
    }
    
	
	/** Tests delete functionality.
     * Pass active as well as inactive report ids.
	 * @throws Exception
	 */
	public void testDeleteCompletedReport() throws Exception {

         EntityKey key = CommonEntityKeyFactory.createSimpleCompletedReportEntityKey("10219");  
            // Deletes Completed Report
            getStandardReportService().deleteCompletedReport(key,this.getUserAdminService().getUserByName("bea"));
        }	
    
    
    /** Tests inactivate functionality.
     * @throws Exception
     */
    public void testInactivateCompletedReport() throws Exception {

         EntityKey key = CommonEntityKeyFactory.createSimpleCompletedReportEntityKey("10217");      
            // Deletes Completed Report
            getStandardReportService().inactivateCompletedReport(key,this.getUserAdminService().getUserByName("bea"));
    }
      
    /**
     * Tests ReportFilter
     * @throws Exception
     */
    public void testGetCompletedReportFilters() throws Exception
    {
        ReportFilter reportFilter=getStandardReportService().getCompletedReportFilter();
        
        System.out.println("ReportFilter:"+reportFilter);
        
    }
    
}