/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.springframework.orm.hibernate3.HibernateTemplate;

/**
 * SignedApplicationReportTest
 * @created Sep 18, 2006 3:16:43 PM
 * @author DNS   MANSOG
 */
public class SignedApplicationReportTest extends AbstractReportTest {

    private static final String SUMMARY_QUERY_NAME = "signedAppReport.Summary";
    private static final String DETAIL_QUERY_NAME = "signedAppReport.Detailed";
    private Date                startTime  = DateUtils.createCalendar(2000, 1, 1).getTime();
    private Date                endTime    = DateUtils.getCurrentDate();
    private Integer             incomeYear = new Integer(2005);
    private String[]            paramNames = new String[] { "type", CommonCriteria.IS_ALL,
            CommonCriteria.VISNS, CommonCriteria.FACILITIES, CommonCriteria.INCOME_YEAR,
            CommonCriteria.START_DATE, CommonCriteria.END_DATE };

    /**
     * A default constructor
     * @param testName
     */
    public SignedApplicationReportTest(String testName) {
        super(testName);
    }

    public void testQueryTypeNone() throws Exception {
        BigDecimal[] visns = new BigDecimal[] { BigDecimal.valueOf(0) };
        BigDecimal[] facilities = new BigDecimal[] { BigDecimal.valueOf(0) };
        Object[] paramValues = new Object[] { "none", null, visns, facilities, incomeYear, null, null };

        processQuery(SUMMARY_QUERY_NAME, paramNames, paramValues);
    }

    public void testQueryTypeSite() throws Exception {
        BigDecimal[] visns = new BigDecimal[] { BigDecimal.valueOf(0) };
        BigDecimal[] facilities = new BigDecimal[] { BigDecimal.valueOf(1000098) };

        Object[] paramValues = new Object[] { "site", null, visns, facilities, incomeYear, null, null };

        processQuery(SUMMARY_QUERY_NAME, paramNames, paramValues);
    }

    public void testQueryTypeSiteAll() throws Exception {
        BigDecimal[] visns = new BigDecimal[] { BigDecimal.valueOf(0) };
        BigDecimal[] facilities = new BigDecimal[] { BigDecimal.valueOf(0) };

        Object[] paramValues = new Object[] { "site", "all", visns, facilities, incomeYear, null, null };

        processQuery(SUMMARY_QUERY_NAME, paramNames, paramValues);
    }

    public void testQueryTypeVisns() throws Exception {
        BigDecimal[] visns = new BigDecimal[] { BigDecimal.valueOf(1002219) };
        BigDecimal[] facilities = new BigDecimal[] { BigDecimal.valueOf(0) };

        Object[] paramValues = new Object[] { "visn", null, visns, facilities, incomeYear, null, null };

        processQuery(SUMMARY_QUERY_NAME, paramNames, paramValues);
    }

    private void processQuery(String queryName, String[] paramNames, Object[] paramValues) {

        HibernateTemplate tpl = this.getHibernateTemplate();

        List results = tpl.findByNamedQueryAndNamedParam(queryName, paramNames, paramValues);
        assertNotNull(results);

        for (Iterator i = results.iterator(); i.hasNext();) {
            Object row = i.next();
            if (row instanceof Object[]) {
                Object[] elements = (Object[]) row;
                for (int pos = 0; pos < elements.length; pos++) {
                    System.out.println("Element['" + pos + "]: " + elements[pos]);
                }
            } else if (row instanceof Map) {
                Map data = (Map) row;
                for (Iterator iter = data.entrySet().iterator(); iter.hasNext();) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    System.out.println("Key: " + entry.getKey() + " Value: " + entry.getValue());
                }
            } else if (row instanceof List) {
                List data = (List) row;
                for (Iterator iter = data.iterator(); iter.hasNext();) {
                    System.out.println("Value: " + iter.next());
                }
            } else {
                System.out.println("element: " + row);
            }
        }
    }
    public void testSummaryViewStationNum() throws Exception {
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport(this.getStandadReport(StandardReport.CODE_IV_1.getCode()));
        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
        parameterSet.setFileType(this.getReportExportedType(ReportExportedType.PDF.getName()));

        parameterSet.setBeginIncomeYear(incomeYear);

        parameterSet.setFacilityDisplayBy(getReportFacilityDisplayBy(ReportFacilityDisplayBy.CODE_SITE
                .getCode()));
        ReportFacility facility = new ReportFacility();
        facility.setFacility(getLookupService().getVaFacilityByStationNumber("552"));
        parameterSet.addFacility(facility);

        setup.setParameterSet(parameterSet);
        this.generateReport(this.getESRUser(), setup);
    }

    public void testSummaryViewDefault() throws Exception {
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport(this.getStandadReport(StandardReport.CODE_IV_1.getCode()));
        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
        parameterSet.setFileType(this.getReportExportedType(ReportExportedType.PDF.getName()));
        parameterSet.setBeginIncomeYear(incomeYear);

        setup.setParameterSet(parameterSet);
        this.generateReport(this.getESRUser(), setup);
    }
    
    public void testDetailQueryTypeNone() throws Exception {
        BigDecimal[] visns = new BigDecimal[] { BigDecimal.valueOf(0) };
        BigDecimal[] facilities = new BigDecimal[] { BigDecimal.valueOf(0) };
        Object[] paramValues = new Object[] { "none", null, visns, facilities, incomeYear, null, null };

        processQuery(DETAIL_QUERY_NAME, paramNames, paramValues);
    }

    public void testDetailQueryTypeSite() throws Exception {
        BigDecimal[] visns = new BigDecimal[] { BigDecimal.valueOf(0) };
        BigDecimal[] facilities = new BigDecimal[] { BigDecimal.valueOf(1000098) };

        Object[] paramValues = new Object[] { "site", null, visns, facilities, incomeYear, null, null };

        processQuery(DETAIL_QUERY_NAME, paramNames, paramValues);
    }

    public void testDetailQueryTypeSiteAll() throws Exception {
        BigDecimal[] visns = new BigDecimal[] { BigDecimal.valueOf(0) };
        BigDecimal[] facilities = new BigDecimal[] { BigDecimal.valueOf(0) };

        Object[] paramValues = new Object[] { "site", "all", visns, facilities, incomeYear, null, null };

        processQuery(DETAIL_QUERY_NAME, paramNames, paramValues);
    }

    public void testDetailQueryTypeVisns() throws Exception {
        BigDecimal[] visns = new BigDecimal[] { BigDecimal.valueOf(1002219) };
        BigDecimal[] facilities = new BigDecimal[] { BigDecimal.valueOf(0) };

        Object[] paramValues = new Object[] { "visn", null, visns, facilities, incomeYear, null, null };

        processQuery(DETAIL_QUERY_NAME, paramNames, paramValues);
    }

     public void testDetailViewStationNum() throws Exception {
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport(this.getStandadReport(StandardReport.CODE_IV_1.getCode()));

        parameterSet.setFileType(this.getReportExportedType(ReportExportedType.PDF.getName()));

        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
        parameterSet.setBeginIncomeYear(incomeYear);

        parameterSet.setFacilityDisplayBy(getReportFacilityDisplayBy(ReportFacilityDisplayBy.CODE_SITE
                .getCode()));
        ReportFacility facility = new ReportFacility();
        facility.setFacility(getLookupService().getVaFacilityByStationNumber("552"));
        parameterSet.addFacility(facility);

        setup.setParameterSet(parameterSet);
        this.generateReport(this.getESRUser(), setup);
    }

    public void testDetailViewDefault() throws Exception {
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport(this.getStandadReport(StandardReport.CODE_IV_1.getCode()));
        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
        parameterSet.setFileType(this.getReportExportedType(ReportExportedType.PDF.getName()));
        parameterSet.setBeginIncomeYear(incomeYear);

        setup.setParameterSet(parameterSet);
        this.generateReport(this.getESRUser(), setup);
    }

}