/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes

import java.util.Iterator;
import java.util.List;
// Framework classes

import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.service.ServiceException;

// ESR classes
import gov.va.med.esr.common.model.lookup.ReportType;
import gov.va.med.esr.common.model.report.ReportSetupLite;
import gov.va.med.esr.common.model.report.SimpleCompletedReport;
import gov.va.med.esr.service.CompletedReportService;
import gov.va.med.esr.service.CompletedReportsSearchQueryInfo;
import gov.va.med.esr.service.ScheduledReportService;
import gov.va.med.esr.service.ReportFilterSearchQueryInfo;

/**
 * Junit for testing schedule and unscheduling reports.
 * 
 * @author DNS   CHENJ2
 */
public class SearchReportTest extends AbstractReportTest {

	private CompletedReportService completedReportService;
	private ScheduledReportService scheduledReportService;

	/**
	 * A default constructor
	 * @param testName
	 */
	public SearchReportTest(String testName) {
		super(testName);
	}
	
	public void customSetUp() throws Exception {
		//setupScheduledReport();
	}
	
	/**
	 * @return Returns the scheduledReportService.
	 */
	protected ScheduledReportService getScheduledReportService() {
		if( this.scheduledReportService == null ) {
			this.scheduledReportService = (ScheduledReportService)this.applicationContext.getBean( "scheduledReportService" );
		}
		return this.scheduledReportService;
	}
	
	/**
	 * @return Returns the completedReportService.
	 */
	protected CompletedReportService getCompletedReportService() {
		if( this.completedReportService == null ) {
			this.completedReportService = (CompletedReportService)this.applicationContext.getBean( "completedReportService" );
		}
		return this.completedReportService;
	}
		
	/**
	 * Test case for searching completed reports 
	 * @throws ServiceException
	 */
	public void testSearchCompletedReport() throws ServiceException {
		CompletedReportsSearchQueryInfo criteria = new CompletedReportsSearchQueryInfo();
		criteria.setStandardReport(this.getLookupService().getStandardReportByCode("QM 14"));
		criteria.setReportType((ReportType) this.getLookupService().getByCode(ReportType.class, ReportType.WORKLOAD));
		criteria.setReportExportedType((ReportExportedType) this.getLookupService().getByCode(ReportExportedType.class, ReportExportedType.PDF));
		criteria.setReportParameters("Days Between Updates");
		criteria.setUser(this.getUserAdminService().getUserByName("bea"));
		criteria.setDateFrom(this.getDate(2007, 0, 17));
		criteria.setDateTo(this.getDate(2007, 0, 19));
		List reports = this.getCompletedReportService().search(criteria);
		SimpleCompletedReport rpt = null;
		
		if (reports != null) {
			for (Iterator i=reports.iterator(); i.hasNext();) {
				rpt = (SimpleCompletedReport) i.next();
				System.out.println("CompletedReport ID = " + rpt.getEntityKey().getKeyValueAsString());
			}
		}
	}
	
	/**
	 * Test case for searching scheduled reports
	 * @throws ServiceException
	 */
	public void testSearchScheduledReport() throws ServiceException {
		ReportFilterSearchQueryInfo criteria = new ReportFilterSearchQueryInfo();
		criteria.setStandardReport(this.getLookupService().getStandardReportByCode("QM 14"));
		criteria.setReportType((ReportType) this.getLookupService().getByCode(ReportType.class, ReportType.WORKLOAD));
		criteria.setReportExportedType((ReportExportedType) this.getLookupService().getByCode(ReportExportedType.class, ReportExportedType.PDF));
		criteria.setUser(this.getUserAdminService().getUserByName("bea"));
		criteria.setDateFrom(this.getDate(2007, 0, 7));
		criteria.setDateTo(this.getDate(2007, 0, 9));
		
		List reports = this.getScheduledReportService().search(criteria);
		ReportSetupLite rpt = null;
		
		if (reports != null) {
			for (Iterator i=reports.iterator(); i.hasNext();) {
				rpt = (ReportSetupLite) i.next();
				System.out.println("ScheduledReport ID = " + rpt.getEntityKey().getKeyValueAsString());
			}
		}
	}
}