/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.Date;
// Framework classes

import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSchedule;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * Junit for testing schedule and unscheduling reports.
 * 
 * @author DNS   CHENJ2
 */
public class ScheduleReportTest extends AbstractReportTest {

    private Date startTime = DateUtils.getFiscalYearFirstQuarter( 2000, true ).getTime(); 
    private Date endTime =  new Date();
	private ReportSetup setup = null;
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public ScheduleReportTest(String testName) {
		super(testName);
	}
	
	public void customSetUp() throws Exception {
		setupScheduledReport();
	}
	
	private void setupScheduledReport() throws Exception {
        setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport( this.getStandadReport( StandardReport.CODE_QM_3.getCode()  ) );
        setup.setSetupUser(this.getESRUser());
        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
        parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
        parameterSet.setFromDate( startTime );
        parameterSet.setToDate( endTime );
        setup.setParameterSet(parameterSet);
        
        ReportSchedule schedule = new ReportSchedule();
        schedule.setScheduleType((ReportScheduleType) this.getLookupService().getByCode(ReportScheduleType.class, ReportScheduleType.DAY_OF_MONTH));
        schedule.setRunFrequency((ReportRunFrequency)this.getLookupService().getByCode(ReportRunFrequency.class, ReportRunFrequency.MONTHLY));
        schedule.setDayOfMonth((DayOfMonth) this.getLookupService().getByCode(DayOfMonth.class, DayOfMonth.CODE_15TH));
        schedule.setHour(new Integer(5));
        schedule.setMinute(new Integer(0));
        setup.setSchedule(schedule);
    
        this.getStandardReportService().scheduleReport(this.getESRUser(), setup);
	}

	public void testCancelSheduledReport() throws Exception {
		this.getStandardReportService().cancelScheduledReport(setup.getEntityKey(),this.getESRUser());
		// canceling a specific report with id:
		//		this.getStandardReportService().cancelScheduledReport(EntityKeyFactory.createEntityKey("21333072", ReportSetup.class));

	}
	
}