/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

// Library classes
import org.springframework.orm.hibernate3.HibernateTemplate;

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author DNS   LEV
 */
public class SSNStatisticsReportTest extends AbstractReportTest {

	/**
	 * A default constructor
	 * @param testName
	 */
	public SSNStatisticsReportTest(String testName) {
		super(testName);
      // Uncomment this line if you want the test report
      // to be persisted in DEV database
      // this.setDefaultRollback( false );
	}
	
 /*  public void testSSNStatisticsQuery() throws Exception {
      
      HibernateTemplate tpl = this.getHibernateTemplate();
      
      String[] paramNames = new String[]{ };
     
      
      Object[] paramValues = new Object[]{ 
                                            };

      List results = tpl.findByNamedQueryAndNamedParam( "IV4.DatabaseSSNStatisticsReport",
                                                        paramNames,
                                                        paramValues );
      assertNotNull( results );
      
      for( Iterator i=results.iterator(); i.hasNext();  ) {
         Object row = i.next();
         if( row instanceof Object[] ) {
            Object[] elements = (Object[])row;
            for( int pos=0; pos<elements.length; pos++ ) {
               logger.info( "Element['" + pos + "]: " + elements[pos]);
            }
         }
         else if( row instanceof Map ) {
            Map data = (Map)row;
            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
               Map.Entry entry = (Map.Entry)iter.next();
               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
            }
         }
         else if( row instanceof List ) {
            List data = (List)row;
            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
               logger.info( "Value: " + iter.next() );
            }
         }
         else {
            logger.info( "element: " + row );
         }
      }
   }
  
   public void testSSNInvalidResonsQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ 
	                                           };
	     
	      
	      Object[] paramValues = new Object[]{ 
	                                            };

	      List results = tpl.findByNamedQueryAndNamedParam( "IV4.SSNStatisticsInvalidReasons",
	                                                        paramNames,
	                                                        paramValues );
	      assertNotNull( results );
	      
	      for( Iterator i=results.iterator(); i.hasNext();  ) {
	         Object row = i.next();
	         if( row instanceof Object[] ) {
	            Object[] elements = (Object[])row;
	            for( int pos=0; pos<elements.length; pos++ ) {
	               logger.info( "Element['" + pos + "]: " + elements[pos]);
	            }
	         }
	         else if( row instanceof Map ) {
	            Map data = (Map)row;
	            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
	               Map.Entry entry = (Map.Entry)iter.next();
	               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
	            }
	         }
	         else if( row instanceof List ) {
	            List data = (List)row;
	            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
	               logger.info( "Value: " + iter.next() );
	            }
	         }
	         else {
	            logger.info( "element: " + row );
	         }
	      }
	   }*/

	/** Tests summary view in pdf
	 * @throws Exception
	 */
	public void testSSAStatisticsView() throws Exception {
		
		//Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		//Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_IV_4.getCode() ) );
		//parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		//parameterSet.setFromDate( startTime );
		//parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}
	

}