/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.Date;
import java.util.Iterator;
import java.util.List;

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportRegistryType;
import gov.va.med.esr.common.model.report.ReportSetup;

/**
 * Junit for all QM27 reports.
 * 
 * @author Muddaiah Ranga
 */
public class QM27ReportTest extends AbstractReportTest {
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public QM27ReportTest(String testName) {
		super(testName);
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
    public void testDetailEDFView() throws Exception {
        
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport( this.getStandadReport( StandardReport.CODE_QM_27.getCode()  ) );
        parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
        parameterSet.setBatchNumber(new Integer(20406373));
        parameterSet.setExceptionType(this.getReportExceptionTypeByCode("5"));
        setup.setParameterSet(parameterSet);
        
        this.getStandardReportService().generateReport( this.getESRUser(), setup );
    }
    
    /** Test query for a summary report
     * @throws Exception
     */
    public void testDetailCSVView() throws Exception {
        
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport( this.getStandadReport( StandardReport.CODE_QM_27.getCode()  ) );
        parameterSet.setFileType( this.getReportExportedType( ReportExportedType.CSV.getCode() ) );
        parameterSet.setBatchNumber(new Integer(20406373));
        parameterSet.setExceptionType(this.getReportExceptionTypeByCode("5"));
        setup.setParameterSet(parameterSet);
        
        this.getStandardReportService().generateReport( this.getESRUser(), setup );
    }

    private ReportExceptionType getReportExceptionTypeByCode(String code) throws Exception{
        try {
            return (ReportExceptionType)this.getLookupService().getByCode(ReportExceptionType.class,code);
        } catch(Exception ex) {
            throw ex;
        }
    }
}