/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.Date;
import java.util.Iterator;
import java.util.List;

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportRegistryType;
import gov.va.med.esr.common.model.report.ReportSetup;

/**
 * Junit for all QM26 reports.
 * 
 * @author Muddaiah Ranga
 */
public class QM26ReportTest extends AbstractReportTest {

    private Date startTime = DateUtils.getFiscalYearFirstQuarter( 2000, true ).getTime(); 
    private Date endTime =  new Date();
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public QM26ReportTest(String testName) {
		super(testName);
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryView() throws Exception {
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_26.getCode()  ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
        parameterSet.setFromDate( startTime );
        parameterSet.setToDate( endTime );
        
        List registries = getAllRegistries();
        if(registries != null) {
            for(Iterator iter=registries.iterator(); iter.hasNext();) {
                RegistryType type = (RegistryType)iter.next();
                ReportRegistryType reportRegistryType = new ReportRegistryType();
                reportRegistryType.setRegistryType(type);
                parameterSet.addRegistryType(reportRegistryType);
            }
        }
		setup.setParameterSet(parameterSet);
		
		this.getStandardReportService().generateReport( this.getESRUser(), setup );
	}

    private List getAllRegistries() throws Exception{
        try {
            return this.getLookupService().findAll(RegistryType.class);
        } catch(Exception ex) {
            throw ex;
        }
    }
}