/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

// Library classes
import org.springframework.orm.hibernate3.HibernateTemplate;

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author Venky Kullampalle
 */
public class PseudoSSNReportTest extends AbstractReportTest {

	/**
	 * A default constructor
	 * @param testName
	 */
	public PseudoSSNReportTest(String testName) {
		super(testName);
      // Uncomment this line if you want the test report
      // to be persisted in DEV database
      // this.setDefaultRollback( false );
	}
	
   public void testPseudoSSNQuery() throws Exception {
      
      HibernateTemplate tpl = this.getHibernateTemplate();
      
      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
                                          CommonCriteria.END_DATE};
     
      
      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime()
                                            };

      List results = tpl.findByNamedQueryAndNamedParam( "IV5.pseudo_ssn_summary",
                                                        paramNames,
                                                        paramValues );
      assertNotNull( results );
      
      for( Iterator i=results.iterator(); i.hasNext();  ) {
         Object row = i.next();
         if( row instanceof Object[] ) {
            Object[] elements = (Object[])row;
            for( int pos=0; pos<elements.length; pos++ ) {
               logger.info( "Element['" + pos + "]: " + elements[pos]);
            }
         }
         else if( row instanceof Map ) {
            Map data = (Map)row;
            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
               Map.Entry entry = (Map.Entry)iter.next();
               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
            }
         }
         else if( row instanceof List ) {
            List data = (List)row;
            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
               logger.info( "Value: " + iter.next() );
            }
         }
         else {
            logger.info( "element: " + row );
         }
      }
   }
  
   public void testPseudoSSNSubQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE
	                                           };
	     
	      
	      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
	                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime()
	                                            };

	      List results = tpl.findByNamedQueryAndNamedParam( "IV5.pseudo_ssn_subreport_summary",
	                                                        paramNames,
	                                                        paramValues );
	      assertNotNull( results );
	      
	      for( Iterator i=results.iterator(); i.hasNext();  ) {
	         Object row = i.next();
	         if( row instanceof Object[] ) {
	            Object[] elements = (Object[])row;
	            for( int pos=0; pos<elements.length; pos++ ) {
	               logger.info( "Element['" + pos + "]: " + elements[pos]);
	            }
	         }
	         else if( row instanceof Map ) {
	            Map data = (Map)row;
	            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
	               Map.Entry entry = (Map.Entry)iter.next();
	               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
	            }
	         }
	         else if( row instanceof List ) {
	            List data = (List)row;
	            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
	               logger.info( "Value: " + iter.next() );
	            }
	         }
	         else {
	            logger.info( "element: " + row );
	         }
	      }
	   }

   public void testPseudoSSNDetailQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE
	                                           };
	     
	      
	      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
	                                           DateUtils.createCalendar( 2007, 1, 1 ).getTime()
	                                            };

	      List results = tpl.findByNamedQueryAndNamedParam( "IV5.pseudo_ssn_detail",
	                                                        paramNames,
	                                                        paramValues );
	      assertNotNull( results );
	      
	      for( Iterator i=results.iterator(); i.hasNext();  ) {
	         Object row = i.next();
	         if( row instanceof Object[] ) {
	            Object[] elements = (Object[])row;
	            for( int pos=0; pos<elements.length; pos++ ) {
	               logger.info( "Element['" + pos + "]: " + elements[pos]);
	            }
	         }
	         else if( row instanceof Map ) {
	            Map data = (Map)row;
	            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
	               Map.Entry entry = (Map.Entry)iter.next();
	               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
	            }
	         }
	         else if( row instanceof List ) {
	            List data = (List)row;
	            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
	               logger.info( "Value: " + iter.next() );
	            }
	         }
	         else {
	            logger.info( "element: " + row );
	         }
	      }
	   }

	
	public void testPseudoSSNSummaryView() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_IV_5.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );			
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}
	
	
	public void testPseudoSSNDetailView() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_IV_5.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}
}