/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes

// Library classes
import org.springframework.context.MessageSource;

// ESR classes
import gov.va.med.esr.common.report.data.CommonExtractFileCriteria;
import gov.va.med.esr.common.report.data.MainFileCriteria;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author DNS   LEV
 */
public class OPPExtractFileReportTest extends AbstractReportTest {

	private MessageSource reportBundle = null;
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public OPPExtractFileReportTest(String testName) {
		super(testName);
      this.setDefaultRollback( false );
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testMainFile() throws Exception {
		MainFileCriteria criteria = new MainFileCriteria( this.getResourceBundle() );
		criteria.setRecords( new Integer( 200 ) );
		criteria.setAutoEnrolledRecords( new Integer(20) );
		criteria.setCancelledDeclinedEnrollees( new Integer(45) );
		criteria.setDeceasedBeneficiaries( new Integer(56) );
		criteria.setIneligibleBeneficiaries( new Integer(24) );
		criteria.setInsurances( new Integer(18) );
		criteria.setOfficialEnrollees( new Integer(32) );
		criteria.setRequiredMeansTests( new Integer(39) );
		criteria.setTotalEnrollees( new Integer(48) );
		criteria.setUnOfficialEnrollees( new Integer(47) );
		
		this.generateReport( criteria );
	}

	/** Test query for a summary report
	 * @throws Exception
	 */

	public void testPeriodOfServiceFile() throws Exception {
		CommonExtractFileCriteria criteria = 
			new CommonExtractFileCriteria( CommonExtractFileCriteria.PERIODOFSERVICE_FILE, 
													 this.getResourceBundle() );
		criteria.setRecords( new Integer( 450 ) );
		
		this.generateReport( criteria );
	}

	public void testEligibilityFile() throws Exception {
		CommonExtractFileCriteria criteria = 
			new CommonExtractFileCriteria( CommonExtractFileCriteria.ELIGIBILITY_FILE, 
													 this.getResourceBundle() );
		criteria.setRecords( new Integer( 350 ) );
		
		this.generateReport( criteria );
	}

	public void testRatedDisabilitiesFile() throws Exception {
		CommonExtractFileCriteria criteria = 
			new CommonExtractFileCriteria( CommonExtractFileCriteria.RATEDDISABILITIES_FILE, 
													 this.getResourceBundle() );
		criteria.setRecords( new Integer( 150 ) );
		
		this.generateReport( criteria );
	}
	
	public void testCombatEpisodesFile() throws Exception {
		CommonExtractFileCriteria criteria = 
			new CommonExtractFileCriteria( CommonExtractFileCriteria.COMBATEPISODES_FILE, 
													 this.getResourceBundle() );
		criteria.setRecords( new Integer( 150 ) );
		
		this.generateReport( criteria );
	}
	
	protected void generateReport( CommonExtractFileCriteria criteria ) throws Exception {
		this.getStandardReportService().generateOPPReport( this.getESRUser(), criteria );
	}
	
	protected MessageSource getResourceBundle() {
		
		if( this.reportBundle == null ) {
			reportBundle = (MessageSource)this.applicationContext.getBean( "reportResources" ); 
		}
		return reportBundle;
	}
}