/********************************************************************
/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.report.ReportExportedType;

// ESR classes
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.lookup.ReportPeriodType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportPeriod;

/**
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author DNS   LEV
 */
public class MSTStatusReportTest extends AbstractReportTest {

	/**
	 * A default constructor
	 * @param testName
	 */
	public MSTStatusReportTest(String testName) {
		super(testName);
      
      // Uncomment this line if you want the test report
      // to be persisted in DEV database
      // this.setDefaultRollback( false );
	}

	/**
	 * Displays data for the specific quarter in the specific fiscal year
	 */
	public void testQuarterlyReportInPDF() throws Exception {
		
		// Create a report period
		ReportPeriod period = new ReportPeriod();
		period.setType( this.getReportPeriodType( ReportPeriodType.CODE_QUARTERLY.getCode() ) );
		period.setYear( new Integer( 2005 ) );
		period.setQuarter( getRandomQuarter() );

		// Create report parameter set
		ReportParameterSet parameterSet = new ReportParameterSet();
		parameterSet.setReportPeriod( period );
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );

		// Create a report setup
		ReportSetup setup = new ReportSetup();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_10.getCode() ) );
		setup.setParameterSet( parameterSet );
		setup.setSetupUser( this.getESRUser() );

		this.generateReport( this.getESRUser(), setup );
	}
	
	/**
	 * Displays data grouped by quarter in the specific date range
	 * @throws Exception
	 */
	public void testDateRangeReportInPDF() throws Exception {
		
		// Create a report period
		ReportPeriod period = new ReportPeriod();
		period.setType( this.getReportPeriodType( ReportPeriodType.CODE_DATE_RANGE.getCode() ) );
		period.setFromDate( DateUtils.createCalendar(2006,1,1).getTime() );
		period.setToDate( DateUtils.createCalendar(2006,4,30).getTime() );
		
		// Create report parameter set
		ReportParameterSet parameterSet = new ReportParameterSet();
		parameterSet.setReportPeriod( period );
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );

		// Create a report setup
		ReportSetup setup = new ReportSetup();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_10.getCode() ) );
		setup.setParameterSet( parameterSet );
		setup.setSetupUser( this.getESRUser() );

		this.generateReport( this.getESRUser(), setup );
	}
	
	/**
	 * Displays data grouped by quarter in the specific fiscal year
	 * @throws Exception
	 */
	public void testSpecificFiscalReport() throws Exception {

		// Create a report period
		ReportPeriod period = new ReportPeriod();
		period.setType( this.getReportPeriodType( ReportPeriodType.CODE_FISCAL_YEAR.getCode() ) );
		period.setYear( new Integer( 2005 ) );

		// Create report parameter set
		ReportParameterSet parameterSet = new ReportParameterSet();
		parameterSet.setReportPeriod( period );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );

		// Create a report setup
		ReportSetup setup = new ReportSetup();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_10.getCode() ) );
		setup.setParameterSet( parameterSet );
		setup.setSetupUser( this.getESRUser() );

		this.generateReport( this.getESRUser(), setup );
	}
	
	/**
	 * Displays data of all fiscal years up to the specific fiscal years.  
	 * Data are grouped by quarter.
	 * @throws Exception
	 */
	public void testAllFiscalReport() throws Exception {

		// Create a report period
		ReportPeriod period = new ReportPeriod();
		period.setType( this.getReportPeriodType( ReportPeriodType.CODE_ALL_FISCAL_YEARS.getCode() ) );
		period.setYear( new Integer( 2005 ) );

		// Create report parameter set
		ReportParameterSet parameterSet = new ReportParameterSet();
		parameterSet.setReportPeriod( period );
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );

		// Create a report setup
		ReportSetup setup = new ReportSetup();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_10.getCode() ) );
		setup.setParameterSet( parameterSet );
		setup.setSetupUser( this.getESRUser() );

		this.generateReport( this.getESRUser(), setup );
	}
}