/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

// Library classes
import org.springframework.orm.hibernate3.HibernateTemplate;

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * InProcessReportTest Created Sep 18, 2006 3:16:43 PM
 * @author DNS   MANSOG
 */
public class InProcessReportTest extends AbstractReportTest {

    private Date startTime = DateUtils.createCalendar(2000, 1, 1).getTime();
    private Date endTime   = DateUtils.getCurrentDate();

    /**
     * A default constructor
     * @param testName
     */
    public InProcessReportTest(String testName) {
        super(testName);
    }

    public void testSummaryQuery() throws Exception {

        String[] paramNames = new String[] { CommonCriteria.START_DATE, CommonCriteria.END_DATE };

        Object[] paramValues = new Object[] { startTime, endTime };

        processQuery("inProcessReport.Summary", paramNames, paramValues);
    }

    public void testDetailByUserQuery() throws Exception {

        String[] paramNames = new String[] { CommonCriteria.START_DATE, CommonCriteria.END_DATE };

        Object[] paramValues = new Object[] { startTime, endTime };

        processQuery("inProcessReport.DetailByUser", paramNames, paramValues);
    }

    public void testDetailByDateQuery() throws Exception {

        String[] paramNames = new String[] { CommonCriteria.START_DATE, CommonCriteria.END_DATE };

        Object[] paramValues = new Object[] { startTime, endTime };

        processQuery("inProcessReport.DetailByDate", paramNames, paramValues);
    }

    private void processQuery(String queryName, String[] paramNames, Object[] paramValues) {

        HibernateTemplate tpl = this.getHibernateTemplate();

        List results = tpl.findByNamedQueryAndNamedParam(queryName, paramNames, paramValues);
        assertNotNull(results);

        for (Iterator i = results.iterator(); i.hasNext();) {
            Object row = i.next();
            if (row instanceof Object[]) {
                Object[] elements = (Object[]) row;
                for (int pos = 0; pos < elements.length; pos++) {
                    logger.info("Element['" + pos + "]: " + elements[pos]);
                }
            } else if (row instanceof Map) {
                Map data = (Map) row;
                for (Iterator iter = data.entrySet().iterator(); iter.hasNext();) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    logger.info("Key: " + entry.getKey() + " Value: " + entry.getValue());
                }
            } else if (row instanceof List) {
                List data = (List) row;
                for (Iterator iter = data.iterator(); iter.hasNext();) {
                    logger.info("Value: " + iter.next());
                }
            } else {
                logger.info("element: " + row);
            }
        }
    }

    /**
     * Tests summary view in pdf
     * @throws Exception
     */
    public void testSummaryView() throws Exception {

        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport(this.getStandadReport(StandardReport.CODE_QM_17.getCode()));
        parameterSet.setReportFormat(this.getReportFormat(ReportFormat.SUMMARY.getCode()));
        parameterSet.setFileType(this.getReportExportedType(ReportExportedType.PDF.getName()));
        parameterSet.setDivision(this.getReportDevision(ReportDivision.ENR.getCode()));
        parameterSet.setFromDate(startTime);
        parameterSet.setToDate(endTime);
        setup.setParameterSet(parameterSet);

        this.generateReport(this.getESRUser(), setup);
    }

    /**
     * Tests detail view in pdf
     * @throws Exception
     */
    public void testDetailViewByDate() throws Exception {

        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport(this.getStandadReport(StandardReport.CODE_QM_17.getCode()));
        parameterSet.setReportFormat(this.getReportFormat(ReportFormat.DETAIL.getCode()));
        parameterSet.setFileType(this.getReportExportedType(ReportExportedType.PDF.getName()));
        parameterSet.setDivision(this.getReportDevision(ReportDivision.ENR.getCode()));
        parameterSet.setFromDate(startTime);
        parameterSet.setToDate(endTime);
        parameterSet.setDetailBy(this.getReportDetailBy(ReportDetailBy.DATE.getCode()));
        setup.setParameterSet(parameterSet);

        this.generateReport(this.getESRUser(), setup);
    }

    /**
     * Tests detail view in pdf
     * @throws Exception
     */
    public void testDetailViewByUser() throws Exception {

        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport(this.getStandadReport(StandardReport.CODE_QM_17.getCode()));
        parameterSet.setReportFormat(this.getReportFormat(ReportFormat.DETAIL.getCode()));
        parameterSet.setFileType(this.getReportExportedType(ReportExportedType.PDF.getName()));
        parameterSet.setDivision(this.getReportDevision(ReportDivision.ENR.getCode()));
        parameterSet.setFromDate(startTime);
        parameterSet.setToDate(endTime);
        parameterSet.setDetailBy(this.getReportDetailBy(ReportDetailBy.LAS.getCode()));
        setup.setParameterSet(parameterSet);

        this.generateReport(this.getESRUser(), setup);
    }
}