/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

// Library classes
import org.springframework.orm.hibernate3.HibernateTemplate;

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.impl.HL7MessageReportDataDAOImpl;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author DNS   KULLAV
 */
public class HL7MessagesReportTest extends AbstractReportTest {

	/**
	 * A default constructor
	 * @param testName
	 */
	public HL7MessagesReportTest(String testName) {
		super(testName);
      // Uncomment this line if you want the test report
      // to be persisted in DEV database
      // this.setDefaultRollback( false );
	}
	
  public void testQuery() throws Exception {
      
      HibernateTemplate tpl = this.getHibernateTemplate();
      
      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
    		  CommonCriteria.MESSAGE_TYPES,
    		  CommonCriteria.ACK_TYPES};      
      
     
      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2005, 1, 1 ).getTime(),
    		  HL7MessageReportDataDAOImpl.INBOUND_SITE_MESSAGES,
    		  HL7MessageReportDataDAOImpl.ACK_TYPES };

      List results = tpl.findByNamedQueryAndNamedParam( "HL7_Message_Traffic",
                                                        paramNames,
                                                        paramValues );
      assertNotNull( results );
      
      for( Iterator i=results.iterator(); i.hasNext();  ) {
         Object row = i.next();
         if( row instanceof Object[] ) {
            Object[] elements = (Object[])row;
            for( int pos=0; pos<elements.length; pos++ ) {
               logger.info( "Element['" + pos + "]: " + elements[pos]);
            }
         }
         else if( row instanceof Map ) {
            Map data = (Map)row;
            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
               Map.Entry entry = (Map.Entry)iter.next();
               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
            }
         }
         else if( row instanceof List ) {
            List data = (List)row;
            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
               logger.info( "Value: " + iter.next() );
            }
         }
         else {
            logger.info( "element: " + row );
         }
      }
   }
  
	public void testQM7View() throws Exception {		
		
		Date startTime =  DateUtils.getCurrentDate();			
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_28.getCode() ) );		
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		parameterSet.setFromDate( (startTime ) );		
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}
	
  public void testQM9View() throws Exception {		
		
		Date startTime =  DateUtils.getCurrentDate();			
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_29.getCode() ) );		
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		parameterSet.setFromDate( (startTime ) );		
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}
  public void testQM12View() throws Exception {		
		
		Date startTime =  DateUtils.getCurrentDate();			
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_30.getCode() ) );		
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );		
		parameterSet.setFromDate( (startTime ) );		
		setup.setParameterSet(parameterSet);		
		this.generateReport( this.getESRUser(), setup );
	}	
	
}