/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.Date;
import java.util.List;

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * Junit for all PH Unconfirmed Days reports.
 * 
 * @author Muddaiah Ranga
 */
public class EED1ReportTest extends AbstractReportTest {

    private Date startTime = DateUtils.getFiscalYearFirstQuarter( 2000, true ).getTime(); 
    private Date endTime =  new Date();
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public EED1ReportTest(String testName) {
		super(testName);
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
//	public void testSummaryView() throws Exception {
//		
//		ReportSetup setup = new ReportSetup();
//		ReportParameterSet parameterSet = new ReportParameterSet();
//		setup.setReport( this.getStandadReport( StandardReport.CODE_EED_1.getCode()  ) );
//		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
//		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
//        parameterSet.setFromDate( startTime );
//        parameterSet.setToDate( endTime );
//		setup.setParameterSet(parameterSet);
//		
//		this.getStandardReportService().generateReport( this.getESRUser(), setup );
//	}
    
//	public void testDetailView() throws Exception {
//      
//          ReportSetup setup = new ReportSetup();
//          ReportParameterSet parameterSet = new ReportParameterSet();
//          setup.setReport( this.getStandadReport( StandardReport.CODE_EED_1.getCode()  ) );
//          parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
//          parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
//          parameterSet.setFromDate( startTime );
//          parameterSet.setToDate( endTime );
//          setup.setParameterSet(parameterSet);
//          
//          this.getStandardReportService().generateReport( this.getESRUser(), setup );
//    }
    
    /** Test query for a summary report
     * @throws Exception
     */
//    public void testSummaryViewVISN() throws Exception {
//        
//        ReportSetup setup = new ReportSetup();
//        ReportParameterSet parameterSet = new ReportParameterSet();
//        setup.setReport( this.getStandadReport( StandardReport.CODE_EED_1.getCode()  ) );
//        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
//        parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
//        parameterSet.setFromDate( startTime );
//        parameterSet.setToDate( endTime );
//        
//        ReportFacilityDisplayBy reportFacilityDisplayBy = (ReportFacilityDisplayBy)this.getLookupService().getByCode(ReportFacilityDisplayBy.class,ReportFacilityDisplayBy.CODE_VISN.getCode());
//        parameterSet.setFacilityDisplayBy(reportFacilityDisplayBy);
//        VAFacility facility = (VAFacility)this.getLookupService().getByName(VAFacility.class,"VISN 10");
//        if(facility != null) {
//            ReportFacility reportFacility = new ReportFacility();
//            reportFacility.setFacility(facility);
//            parameterSet.addFacility(reportFacility);
//        }
//        facility = (VAFacility)this.getLookupService().getByName(VAFacility.class,"VISN 1");
//        if(facility != null) {
//            ReportFacility reportFacility = new ReportFacility();
//            reportFacility.setFacility(facility);
//            parameterSet.addFacility(reportFacility);
//        }
//        
//        setup.setParameterSet(parameterSet);
//        
//        this.getStandardReportService().generateReport( this.getESRUser(), setup );
//    }
    
//      public void testDetailViewVISN() throws Exception {
//      
//      ReportSetup setup = new ReportSetup();
//      ReportParameterSet parameterSet = new ReportParameterSet();
//      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_1.getCode()  ) );
//      parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
//      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
//      parameterSet.setFromDate( startTime );
//      parameterSet.setToDate( endTime );
//      
//      ReportFacilityDisplayBy reportFacilityDisplayBy = (ReportFacilityDisplayBy)this.getLookupService().getByCode(ReportFacilityDisplayBy.class,ReportFacilityDisplayBy.CODE_VISN.getCode());
//      parameterSet.setFacilityDisplayBy(reportFacilityDisplayBy);
//      VAFacility facility = (VAFacility)this.getLookupService().getByName(VAFacility.class,"VISN 10");
//      if(facility != null) {
//          ReportFacility reportFacility = new ReportFacility();
//          reportFacility.setFacility(facility);
//          parameterSet.addFacility(reportFacility);
//      }
//      facility = (VAFacility)this.getLookupService().getByName(VAFacility.class,"VISN 1");
//      if(facility != null) {
//          ReportFacility reportFacility = new ReportFacility();
//          reportFacility.setFacility(facility);
//          parameterSet.addFacility(reportFacility);
//      }
//      
//      setup.setParameterSet(parameterSet);
//      
//      this.getStandardReportService().generateReport( this.getESRUser(), setup );
//    }
    
    /** Test query for a summary report
     * @throws Exception
     */
    public void testSummaryViewSite() throws Exception {
        
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport( this.getStandadReport( StandardReport.CODE_EED_1.getCode()  ) );
        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
        parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
        parameterSet.setFromDate( startTime );
        parameterSet.setToDate( endTime );
        
        ReportFacilityDisplayBy reportFacilityDisplayBy = (ReportFacilityDisplayBy)this.getLookupService().getByCode(ReportFacilityDisplayBy.class,ReportFacilityDisplayBy.CODE_VISN_SITE.getCode());
        parameterSet.setFacilityDisplayBy(reportFacilityDisplayBy);
        VAFacility facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,"552");
        if(facility != null) {
            ReportFacility reportFacility = new ReportFacility();
            reportFacility.setFacility(facility);
            parameterSet.addFacility(reportFacility);
        }
        facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,"900");
        if(facility != null) {
            ReportFacility reportFacility = new ReportFacility();
            reportFacility.setFacility(facility);
            parameterSet.addFacility(reportFacility);
        }
        
        setup.setParameterSet(parameterSet);
        
        this.getStandardReportService().generateReport( this.getESRUser(), setup );
    }
    
      public void testDetailViewSite() throws Exception {
      
      ReportSetup setup = new ReportSetup();
      ReportParameterSet parameterSet = new ReportParameterSet();
      setup.setReport( this.getStandadReport( StandardReport.CODE_EED_1.getCode()  ) );
      parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
      parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getCode() ) );
      parameterSet.setFromDate( startTime );
      parameterSet.setToDate( endTime );
      
      ReportFacilityDisplayBy reportFacilityDisplayBy = (ReportFacilityDisplayBy)this.getLookupService().getByCode(ReportFacilityDisplayBy.class,ReportFacilityDisplayBy.CODE_VISN_SITE.getCode());
      parameterSet.setFacilityDisplayBy(reportFacilityDisplayBy);
      VAFacility facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,"552");
      if(facility != null) {
          ReportFacility reportFacility = new ReportFacility();
          reportFacility.setFacility(facility);
          parameterSet.addFacility(reportFacility);
      }
      facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,"900");
      if(facility != null) {
          ReportFacility reportFacility = new ReportFacility();
          reportFacility.setFacility(facility);
          parameterSet.addFacility(reportFacility);
      }
      
      setup.setParameterSet(parameterSet);
      
      this.getStandardReportService().generateReport( this.getESRUser(), setup );
    }
	
    
    private List getAllFacilities() throws Exception{
        try {
            return this.getLookupService().findAll(VAFacility.class);
        } catch(Exception ex) {
            throw ex;
        }
    }
}