/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.orm.hibernate3.HibernateTemplate;

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.report.jasperreport.data.JasperReportData;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.data.ReportDataService;
import gov.va.med.fw.report.data.ReportDataException;

// ESR classes
import gov.va.med.esr.common.model.lookup.EligibilityFactor;
import gov.va.med.esr.common.model.lookup.ReportEligibilityFactorLU;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.BaseReportLookupParameter;
import gov.va.med.esr.common.model.report.ReportEligibilityFactor;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.impl.EED10ReportDataDAOImpl;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;

/**
 * Junit for EED10 reports.
 * 
 * @author Susan Gallagher
 */
public class EED10ReportTest extends AbstractReportTest {
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public EED10ReportTest(String testName) {
		super(testName);
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryQuery() throws Exception {
        
        ReportDataService reportService = (ReportDataService)applicationContext.getBean("EED10.dataService");
        
        ReportConfiguration config = new ReportConfiguration("EED10", StandardReport.CODE_EED_10.getCode());
        StandardReportCriteria criteria = new StandardReportCriteria();
        
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport( this.getStandadReport( StandardReport.CODE_EED_10.getCode()  ) );
        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
        
        Date startDate = DateUtils.createCalendar( 2008, 6, 1 ).getTime();
        Date endDate = DateUtils.createCalendar( 2008, 7, 24 ).getTime();
        parameterSet.setFromDate(startDate);
        parameterSet.setToDate(endDate);
        
        setup.setParameterSet(parameterSet);
        criteria.setReportSetup(setup);
        config.setQueryCriteria(criteria);
        
        ReportFacilityDisplayBy reportFacilityDisplayBy = 
          (ReportFacilityDisplayBy)this.getLookupService().getByCode(ReportFacilityDisplayBy.class,
                  ReportFacilityDisplayBy.CODE_VISN.getCode());
        parameterSet.setFacilityDisplayBy(reportFacilityDisplayBy);
        
        /*
        VAFacility facility = (VAFacility)this.getLookupService().getByName(VAFacility.class,"VISN 10");
        if(facility != null) {
            ReportFacility reportFacility = new ReportFacility();
            reportFacility.setFacility(facility);
            parameterSet.addFacility(reportFacility);
        }
        facility = (VAFacility)this.getLookupService().getByName(VAFacility.class,"VISN 1");
        if(facility != null) {
            ReportFacility reportFacility = new ReportFacility();
            reportFacility.setFacility(facility);
            parameterSet.addFacility(reportFacility);
        }
   */
    /*
        HashSet eligFactors = new HashSet(1);
        ReportEligibilityFactor factor = new ReportEligibilityFactor();
        ReportEligibilityFactorLU status = (ReportEligibilityFactorLU) getLookupService().getByCode(ReportEligibilityFactorLU.class, 
                ReportEligibilityFactor.getCode());
        factor.setLookup(status);
        eligFactors.add(factor);
        parameterSet.addAllEligibilityFactors(eligFactors);
        */
            
        setup.setParameterSet(parameterSet);
        
        JasperReportData reportData = (JasperReportData) reportService.requestReportData(config);
        boolean dataFound = reportData.getJasperDataSource().next();
        assertTrue("Data returned", dataFound);
	}
    
    public void testDetailQuery() throws Exception {
      
        ReportDataService reportService = (ReportDataService)applicationContext.getBean("EED10.dataService");
        
        ReportConfiguration config = new ReportConfiguration("EED10", StandardReport.CODE_EED_10.getCode());
        StandardReportCriteria criteria = new StandardReportCriteria();
        
        ReportSetup setup = new ReportSetup();
        ReportParameterSet parameterSet = new ReportParameterSet();
        setup.setReport( this.getStandadReport( StandardReport.CODE_EED_10.getCode()  ) );
        parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
        
        Date startDate = DateUtils.createCalendar( 2008, 6, 1 ).getTime();
        Date endDate = DateUtils.createCalendar( 2008, 7, 24 ).getTime();
        parameterSet.setFromDate(startDate);
        parameterSet.setToDate(endDate);
        
        setup.setParameterSet(parameterSet);
        criteria.setReportSetup(setup);
        config.setQueryCriteria(criteria);
        
        ReportFacilityDisplayBy reportFacilityDisplayBy = 
          (ReportFacilityDisplayBy)this.getLookupService().getByCode(ReportFacilityDisplayBy.class,
                  ReportFacilityDisplayBy.CODE_VISN.getCode());
        parameterSet.setFacilityDisplayBy(reportFacilityDisplayBy);
        
        /*
        VAFacility facility = (VAFacility)this.getLookupService().getByName(VAFacility.class,"VISN 10");
        if(facility != null) {
            ReportFacility reportFacility = new ReportFacility();
            reportFacility.setFacility(facility);
            parameterSet.addFacility(reportFacility);
        }
        facility = (VAFacility)this.getLookupService().getByName(VAFacility.class,"VISN 1");
        if(facility != null) {
            ReportFacility reportFacility = new ReportFacility();
            reportFacility.setFacility(facility);
            parameterSet.addFacility(reportFacility);
        }
   */
        setup.setParameterSet(parameterSet);
        
        JasperReportData reportData = (JasperReportData) reportService.requestReportData(config);
        boolean dataFound = reportData.getJasperDataSource().next();
        assertTrue("Data returned", dataFound);
    }
 
}