/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.io.BufferedInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

// Library classes
import org.springframework.core.io.ClassPathResource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;

// Framework classes
import gov.va.med.fw.report.jasperreport.data.JasperReportData;
import gov.va.med.fw.report.ReportService;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.model.report.ReportSetup;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author DNS   LEV
 */
public class CancelledDeclinedReportTest extends AbstractReportTest {

	private static final String SUMMARY_REPORT_NAME = "cancelledDeclinedReport.Summary";
	private static final String DETAIL_REPORT_NAME = "cancelledDeclinedReport.Detail";
	
	private Date startTime = DateUtils.getFiscalYearFirstQuarter( 2005, true ).getTime(); 
	private Date endTime =  DateUtils.getFiscalYearFirstQuarter( 2005, false ).getTime();
	
	/**
	 * A default constructor
	 * @param testName
	 */
	public CancelledDeclinedReportTest(String testName) {
		super(testName);
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryTemplateWithNoVISNAndSite() throws Exception {
		/*
		ReportService service = this.getReportService();
		String name = SUMMARY_REPORT_NAME;
		String output = "QM4-" + name + ".Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, "QM4", ReportType.PDF, output );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, CommonCriteria.SUMMARY_REPORT );
		
		ClassPathResource resource = new ClassPathResource("cancelleddeclined.xml");
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		service.generateReport( config, data );
		*/
		ReportSetup setup = new ReportSetup();
		this.getStandardReportService().generateReport( this.getESRUser(), setup );
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryTemplateWithVISN() throws Exception {
		/*
		ReportService service = this.getReportService();
		String name = SUMMARY_REPORT_NAME;
		String output = "QM4-" + name + ".VISN.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, "QM4", ReportExportedType.PDF, output );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN" );
		
		ClassPathResource resource = new ClassPathResource("cancelleddeclined.xml");
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISN/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		service.generateReport( config, data );
		*/
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryTemplateWithSite() throws Exception {
	/*	
		ReportService service = this.getReportService();
		String name = SUMMARY_REPORT_NAME;
		String output = "QM4-" + name + ".Site.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, "QM4", ReportExportedType.PDF, output );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By Site" );
		
		ClassPathResource resource = new ClassPathResource("cancelleddeclined.xml");
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/Site/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		service.generateReport( config, data );
		*/
	}
	
	/** Test query for a summary report
	 * @throws Exception
	 */
	public void testSummaryTemplateWithVISNAndSite() throws Exception {
		/*
		ReportService service = this.getReportService();
		String name = SUMMARY_REPORT_NAME;
		String output = "QM4-" + name + ".VISN.Site.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, "QM4", ReportExportedType.PDF, output );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Summary Report By VISN - Site" );
		
		ClassPathResource resource = new ClassPathResource("cancelleddeclined.xml");
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Summary/VISNAndSite/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		service.generateReport( config, data );
		*/
	}
	
	/** Test template for a detail report
	 * @throws Exception
	 */
	public void testDetailTemplateWithNoVISNAndSite() throws Exception {
	/*	
		ReportService service = this.getReportService();
		String name = DETAIL_REPORT_NAME;
		String output = "QM4-" + name + ".Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, "QM4", ReportExportedType.PDF, output );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Detail Report" );
		
		ClassPathResource resource = new ClassPathResource("cancelleddeclined.xml");
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		service.generateReport( config, data );
		*/
	}
	
	/** Test template for a summary report
	 * @throws Exception
	 */
	public void testDetailTemplateWithVISN() throws Exception {
		/*
		ReportService service = this.getReportService();
		String name = DETAIL_REPORT_NAME;
		String output = "QM4-" + name + ".VISN.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, "QM4", ReportExportedType.PDF, output );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Detail Report By VISN" );
		
		ClassPathResource resource = new ClassPathResource("cancelleddeclined.xml");
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/VISN/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		service.generateReport( config, data );
		*/
	}
	
	/** Test template for a summary report
	 * @throws Exception
	 */
	public void testDetailTemplateWithSite() throws Exception {
	/*	
		ReportService service = this.getReportService();
		String name = DETAIL_REPORT_NAME;
		String output = "QM4-" + name + ".Site.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, "QM4", ReportExportedType.PDF, output );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Detail Report By Site" );
		
		ClassPathResource resource = new ClassPathResource("cancelleddeclined.xml");
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/Site/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		service.generateReport( config, data );
		*/
	}
	
	/** Test template for a summary report
	 * @throws Exception
	 */
	public void testDetailTemplateWithVISNAndSite() throws Exception {
	/*	
		ReportService service = this.getReportService();
		String name = DETAIL_REPORT_NAME;
		String output = "QM4-" + name + ".VISN.Site.Template.pdf";
		ReportConfiguration config = this.getReportConfiguration( name, "QM4", ReportExportedType.PDF, output );
		config.getResourceMapping().put( CommonCriteria.REPORT_TYPE, "Detail Report By VISN - Site" );
		
		ClassPathResource resource = new ClassPathResource("cancelleddeclined.xml");
		BufferedInputStream stream = new BufferedInputStream( resource.getInputStream() );
		JRXmlDataSource dataSource = new JRXmlDataSource( stream, "/Veterans/Detail/VISNAndSite/Veteran"); 
		JasperReportData data = new JasperReportData( dataSource );
		service.generateReport( config, data );
	*/}

	/**
	 * @param name
	 * @param ID
	 * @param type
	 * @param output
	 * @return
	 * @throws Exception
	 */
	protected ReportConfiguration getReportConfiguration( String name, String ID, ReportExportedType type ) throws Exception {
		return this.getReportConfiguration( name, ID, type, null );
	}
	/**
	 * @param name
	 * @param ID
	 * @param type
	 * @param output
	 * @return
	 * @throws Exception
	 */
	protected ReportConfiguration getReportConfiguration( String name, String ID, ReportExportedType type, String output ) throws Exception {
		/*
		// Create a report configuration
		ReportConfiguration config = new ReportConfiguration( name, ID, type, output != null ? output : ID + "-" + name );
		
		// Populate a map of report parameters
		Map parameters = new HashMap();
		parameters.put( CommonCriteria.START_DATE, this.startTime );
		parameters.put( CommonCriteria.END_DATE, this.endTime );
		parameters.put( CommonCriteria.RUN_DATE, Calendar.getInstance().getTime() );
		parameters.put( CommonCriteria.REPORT_TITLE, "Cancelled/Declined Report" );
		
		// Populate a query criteria
		Map criteria = new HashMap();
		criteria.put( CommonCriteria.START_DATE, this.startTime );
		criteria.put( CommonCriteria.END_DATE, this.endTime );
		
		config.setQueryCriteria( new CommonCriteria( criteria ) );
		config.setResourceMapping( parameters );

		return config;
		*/
		return null;
	}
}