/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

// Library classes
import org.springframework.orm.hibernate3.HibernateTemplate;

// Framework classes
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;

// ESR classes
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.lookup.*;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 5:59:16 PM </br>
 *
 * @author DNS   LEV
 */
public class BadAddressReportTest extends AbstractReportTest {

	/**
	 * A default constructor
	 * @param testName
	 */
	public BadAddressReportTest(String testName) {
		super(testName);
      // Uncomment this line if you want the test report
      // to be persisted in DEV database
      // this.setDefaultRollback( false );
	}
	
   public void testSummaryQuery() throws Exception {
      
      HibernateTemplate tpl = this.getHibernateTemplate();
      
      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
                                          CommonCriteria.END_DATE,
                                          CommonCriteria.BAD_ADDRESS_REASON, 
                                          CommonCriteria.VISNS };
      
      String[] reasons = new String[]{ BadAddressReason.CODE_ADDRESS_NOT_FOUND.getName(), 
                                       BadAddressReason.CODE_HOMELESS.getName(),
                                       BadAddressReason.CODE_OTHER.getName(),
                                       BadAddressReason.CODE_UNDELIVERABLE.getName() };
      List visns=new ArrayList();
      visns.add(new BigDecimal(1002210));
      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2005, 1, 1 ).getTime(),
                                           DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
                                           reasons,
                                           visns};

      List results = tpl.findByNamedQueryAndNamedParam( "badAddressReport.Summary",
                                                        paramNames,
                                                        paramValues );
      assertNotNull( results );
      
      for( Iterator i=results.iterator(); i.hasNext();  ) {
         Object row = i.next();
         if( row instanceof Object[] ) {
            Object[] elements = (Object[])row;
            for( int pos=0; pos<elements.length; pos++ ) {
               logger.info( "Element['" + pos + "]: " + elements[pos]);
            }
         }
         else if( row instanceof Map ) {
            Map data = (Map)row;
            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
               Map.Entry entry = (Map.Entry)iter.next();
               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
            }
         }
         else if( row instanceof List ) {
            List data = (List)row;
            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
               logger.info( "Value: " + iter.next() );
            }
         }
         else {
            logger.info( "element: " + row );
         }
      }
   }
   
   public void testDetailedQuery() throws Exception {
	      
	      HibernateTemplate tpl = this.getHibernateTemplate();
	      
	      String[] paramNames = new String[]{ CommonCriteria.START_DATE, 
	                                          CommonCriteria.END_DATE,
	                                          CommonCriteria.BAD_ADDRESS_REASON, 
	                                          CommonCriteria.VISNS};
	      
	      String[] reasons = new String[]{ BadAddressReason.CODE_ADDRESS_NOT_FOUND.getName(), 
	                                       BadAddressReason.CODE_HOMELESS.getName(),
	                                       BadAddressReason.CODE_OTHER.getName(),
	                                       BadAddressReason.CODE_UNDELIVERABLE.getName() };
	      List visns=new ArrayList();
	      visns.add(new BigDecimal(1002210));
	      Object[] paramValues = new Object[]{ DateUtils.createCalendar( 2005, 1, 1 ).getTime(),
	                                           DateUtils.createCalendar( 2006, 1, 1 ).getTime(),
	                                           reasons,
	                                           visns};
	      
	      List results = tpl.findByNamedQueryAndNamedParam( "badAddressReport.Detail",
	                                                        paramNames,
	                                                        paramValues );
	      assertNotNull( results );
	      
	      for( Iterator i=results.iterator(); i.hasNext();  ) {
	         Object row = i.next();
	         if( row instanceof Object[] ) {
	            Object[] elements = (Object[])row;
	            for( int pos=0; pos<elements.length; pos++ ) {
	               logger.info( "Element['" + pos + "]: " + elements[pos]);
	            }
	         }
	         else if( row instanceof Map ) {
	            Map data = (Map)row;
	            for( Iterator iter=data.entrySet().iterator(); iter.hasNext(); ) {
	               Map.Entry entry = (Map.Entry)iter.next();
	               logger.info( "Key: " + entry.getKey() + " Value: " + entry.getValue() );
	            }
	         }
	         else if( row instanceof List ) {
	            List data = (List)row;
	            for( Iterator iter=data.iterator(); iter.hasNext(); ) {
	               logger.info( "Value: " + iter.next() );
	            }
	         }
	         else {
	            logger.info( "element: " + row );
	         }
	      }
	   }
	/** Tests summary view in pdf
	 * @throws Exception
	 */
	public void testSummaryView() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_5.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
		//parameterSet.setDivision( this.getReportDevision( ReportDivision.ENR.getCode() ) );
		parameterSet.addAllBadAddressReasons( this.getReportBadAddressReasons() );
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);
		ReportFacility facility=new ReportFacility();
		facility.setFacility((VAFacility)getLookupService().getByName(VAFacility.class, "VISN 10"));
		parameterSet.addFacility(facility);
		this.generateReport( this.getESRUser(), setup );
	}
	
	/** Tests summary view by code in pdf
	 * @throws Exception
	 */
	public void testSummaryViewByCode() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_5.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.SUMMARY.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
		//parameterSet.setDivision( this.getReportDevision( ReportDivision.ENR.getCode() ) );
		parameterSet.addBadAddressReason( this.getRandomBadAddressReason() );
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);
		ReportFacility facility=new ReportFacility();
		facility.setFacility((VAFacility)getLookupService().getByName(VAFacility.class, "VISN 10"));
		parameterSet.addFacility(facility);
		this.generateReport( this.getESRUser(), setup );
	}
	
	/** Tests detail view in pdf
	 * @throws Exception
	 */
	public void testDetailView() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_5.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
		//parameterSet.setDivision( this.getReportDevision( ReportDivision.ENR.getCode() ) );
		parameterSet.addAllBadAddressReasons( this.getReportBadAddressReasons() );
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);
		ReportFacility facility=new ReportFacility();
		facility.setFacility((VAFacility)getLookupService().getByName(VAFacility.class, "VISN 10"));
		parameterSet.addFacility(facility);
		this.generateReport( this.getESRUser(), setup );
	}
	
	/** Tests detail view by code in pdf
	 * @throws Exception
	 */
	public void testDetailViewByCode() throws Exception {
		
		Date startTime = DateUtils.createCalendar( 2004, 1, 1 ).getTime(); 
		Date endTime =  DateUtils.getCurrentDate();
		
		ReportSetup setup = new ReportSetup();
		ReportParameterSet parameterSet = new ReportParameterSet();
		setup.setReport( this.getStandadReport( StandardReport.CODE_QM_5.getCode() ) );
		parameterSet.setReportFormat( this.getReportFormat( ReportFormat.DETAIL.getCode() ) );
		parameterSet.setFileType( this.getReportExportedType( ReportExportedType.PDF.getName() ) );
		//parameterSet.setDivision( this.getReportDevision( ReportDivision.ENR.getCode() ) );
		parameterSet.addBadAddressReason( this.getRandomBadAddressReason() );
		parameterSet.setFromDate( startTime );
		parameterSet.setToDate( endTime );
		setup.setParameterSet(parameterSet);
		ReportFacility facility=new ReportFacility();
		facility.setFacility((VAFacility)getLookupService().getByName(VAFacility.class, "VISN 10"));
		parameterSet.addFacility(facility);
		this.generateReport( this.getESRUser(), setup );
	}
}