/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report;

// Java classes
import java.util.List;
import java.util.Set;
import java.util.Iterator;
import java.util.HashSet;

// Library classes
import org.springframework.mail.SimpleMailMessage;
import org.springframework.orm.hibernate3.HibernateTemplate;

// Framework classes
import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.security.UserPrincipal;

// ESR classes
import gov.va.med.esr.service.StandardReportService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.model.report.ReportBadAddressReason;
import gov.va.med.esr.common.model.lookup.ReportDetailBy;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.ReportDivision;
import gov.va.med.esr.common.model.lookup.ReportPeriodType;
import gov.va.med.esr.common.model.lookup.Quarter;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.service.UserAdminService;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 2:30:45 PM </br>
 *
 * @author DNS   LEV
 */
public class AbstractReportTest extends AbstractCommonTestCase {

	/**
	 * An instance of mailService
	 */
	private MailService mailService = null;
	
	/**
	 * An instance of messageTemplate
	 */
	private SimpleMailMessage messageTemplate = null;
	
	/**
	 * An instance of hibernateTemplate
	 */
	private HibernateTemplate hibernateTemplate = null;
	
	/**
	 * An instance of standardReportService
	 */
	private StandardReportService standardReportService = null;
	
   /**
    * An instance of userAdminService
    */
   private UserAdminService userAdminService = null;
   
	/**
	 * A default constructor
	 * @param testName
	 */
	protected AbstractReportTest(String testName) {
		super(testName);
	}
	
	protected void generateReport( UserPrincipal user, ReportSetup setup ) throws Exception {
		this.getStandardReportService().generateReport( user, setup );
	}
	
	/**
	 * @return Returns the hibernateTemplate.
	 */
	protected HibernateTemplate getHibernateTemplate() {
		if( this.hibernateTemplate == null ) {
			this.hibernateTemplate = (HibernateTemplate)this.applicationContext.getBean( "hibernateTemplate" );
		}
		return this.hibernateTemplate;
	}

	/**
	 * @return Returns the hibernateTemplate.
	 */
	protected StandardReportService getStandardReportService() {
		if( this.standardReportService == null ) {
			this.standardReportService = (StandardReportService)this.applicationContext.getBean( "standardReportService" );
		}
		return this.standardReportService;
	}
	   
	/**
	 * @return Returns the messageTemplate.
	 */
	protected SimpleMailMessage getMessageTemplate() {
		if( this.messageTemplate == null ) {
			this.messageTemplate = (SimpleMailMessage)this.applicationContext.getBean( "scheduledReportMessage" );
		}
		return this.messageTemplate;
	}

	/**
	 * @param mailService The mailService to set.
	 */
	protected MailService getMailService() {
		if( this.mailService == null ) {
			this.mailService = (MailService)this.applicationContext.getBean( "mailService" );
		}
		return this.mailService;
	}
	
	protected ESRUserPrincipal getESRUser() throws Exception {
      return this.getUserAdminService().getUserByName("esr");
	}
	
	protected StandardReport getStandadReport( String code ) throws UnknownLookupTypeException, UnknownLookupCodeException {
		return this.getLookupService().getStandardReportByCode( code );
	}
	
	protected ReportPeriodType getReportPeriodType( String code ) throws UnknownLookupTypeException, UnknownLookupCodeException {
		return this.getLookupService().getReportPeriodTypeByCode( code );
	}
	
	protected ReportFormat getReportFormat( String code ) throws UnknownLookupTypeException, UnknownLookupCodeException {
		return this.getLookupService().getReportFormatByCode( code ); 
	}
	
	protected ReportExportedType getReportExportedType( String code ) throws UnknownLookupTypeException, UnknownLookupCodeException {
		return this.getLookupService().getReportExportedTypeByCode( code ); 
	}
	
	protected ReportDivision getReportDevision( String code ) throws UnknownLookupTypeException, UnknownLookupCodeException {
		return this.getLookupService().getReportDivisionByCode( code ); 
	}
    
    protected ReportDetailBy getReportDetailBy( String code ) throws UnknownLookupTypeException, UnknownLookupCodeException {
        return (ReportDetailBy) this.getLookupService().getByCode(ReportDetailBy.class, code); 
    }
    
    protected ReportFacilityDisplayBy getReportFacilityDisplayBy(String code ) throws UnknownLookupTypeException, UnknownLookupCodeException {
        return (ReportFacilityDisplayBy) this.getLookupService().getByCode(ReportFacilityDisplayBy.class, code); 
    }
    
	protected Set getReportBadAddressReasons() throws Exception {
		
      List badAddressReasons = getLookupService().getAllBadAddressReasons();
      Set reportBadAddressReasons = new HashSet();
      for( Iterator i=badAddressReasons.iterator(); i.hasNext(); ) {
      	ReportBadAddressReason reason = new ReportBadAddressReason();
      	reason.setLookup( (BadAddressReason)i.next() );
      	reportBadAddressReasons.add( reason );
      }
		return reportBadAddressReasons;
	}
	
	protected ReportBadAddressReason getRandomBadAddressReason() throws Exception {
      List badAddressReasons = getLookupService().getAllBadAddressReasons();
      BadAddressReason reason = (BadAddressReason)selectRandomly(badAddressReasons);
   	ReportBadAddressReason reportBadAddressReason = new ReportBadAddressReason();
   	reportBadAddressReason.setLookup( reason );
		return reportBadAddressReason;
	}
	
	protected Quarter getRandomQuarter() throws Exception {
		List quarters = this.getLookupService().getAllQuarters();
		Quarter quarter = (Quarter)this.selectRandomly( quarters );
		return quarter;
	}
}