/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class UserProfileHistoryTest extends AbstractHistoryTestCase {

	private static String historyDAOName = "userProfileHistoryDAO";

	private String useridId = "215992";
	
	
	protected String getPersonId() {
		return useridId;
	}
	
	protected Class getRootObjectClass() {
		return ESRUserPrincipalImpl.class;
	}

	protected void getHistoryByChangeTime(ChangeEvent ce) {
		try {
			log("\nRetrieving history for changeTime:" + ce.getTimeStamp());
			HistoricalInfo retrieved = executeDAOGetHistoryByChangeTime(ce);
			assertNotNull("No history object returned", retrieved);
		
			ESRUserPrincipalImpl curr = (ESRUserPrincipalImpl) retrieved.getCurrentVersion();			
			log("\n============ Retrieved current history objects: ============");
			verifyRetrievedHistoryData(curr);
			printHistoryData(curr);
			
			ESRUserPrincipalImpl prev = (ESRUserPrincipalImpl) retrieved.getPreviousVersion();
			log("\n============ Retrieved previous history objects: ============");
			verifyRetrievedHistoryData(prev);			
			printHistoryData(prev);
			
		} catch (Exception e) {
			fail("Can not execute DAO", e);
		}

	}
	
	protected void verifyRetrievedHistoryData(ESRUserPrincipalImpl user) {
		assertNotNull("user", user);
	}
	
	protected void printHistoryData(ESRUserPrincipalImpl user) {
		assertNotNull(user);
		printSet("roles", user.getUserRoles());
		printSet("capabilities", user.getCapabilities());
		printSet("capabilitySets", user.getCapabilitySets());
	}
	
	protected String getHistoryDAOName() {
		return historyDAOName;
	}
	protected void verifyRetrievedHistoryData(Person p) {}

	protected void printHistoryData(Person p) {}
}