/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import java.math.BigDecimal;
import java.util.Set;

import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;

/**
 * @author DNS   CHENJ2
 *
 * Test purple heart registry history 
 **/
public class SHADRegistryHistoryTest extends AbstractRegistryHistoryTest {

	private static String registryId = "20365795";

	private static String historyDAOName = "shadRegistryHistoryDAO";


	protected void printHistoryData(Registry r) {
		super.printHistoryData(r);
		if (r != null) {
			SHAD shad = (SHAD) r;
			printSet("documents", shad.getDocuments());
		}
	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getRegistryId() {
		return registryId;
	}
}