/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import java.math.BigDecimal;
import java.util.Set;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.persistent.DAOException;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class RoleHistoryTest extends AbstractHistoryTestCase {

	private static String historyDAOName = "roleHistoryDAO";

	private String roleId = "20380991";
	
	
	protected String getPersonId() {
		return roleId;
	}
	
	protected Class getRootObjectClass() {
		return ESRRolePrincipalImpl.class;
	}

	protected void getHistoryByChangeTime(ChangeEvent ce) {
		try {
			log("\nRetrieving history for changeTime:" + ce.getTimeStamp());
			HistoricalInfo retrieved = executeDAOGetHistoryByChangeTime(ce);
			assertNotNull("No history object returned", retrieved);
		
			ESRRolePrincipalImpl curr = (ESRRolePrincipalImpl) retrieved.getCurrentVersion();			
			log("\n============ Retrieved current history objects: ============");
			verifyRetrievedHistoryData(curr);
			printHistoryData(curr);
			
			ESRRolePrincipalImpl prev = (ESRRolePrincipalImpl) retrieved.getPreviousVersion();
			log("\n============ Retrieved previous history objects: ============");
			verifyRetrievedHistoryData(prev);			
			printHistoryData(prev);
			
		} catch (Exception e) {
			fail("Can not execute DAO", e);
		}

	}
	
	protected void verifyRetrievedHistoryData(ESRRolePrincipalImpl role) {
		assertNotNull("role", role);
	}
	
	protected void printHistoryData(ESRRolePrincipalImpl role) {
		assertNotNull(role);
		printSet("capabilities", role.getCapabilities());
		printSet("capabilitySets", role.getCapabilitySets());
	}
	
	protected String getHistoryDAOName() {
		return historyDAOName;
	}
	protected void verifyRetrievedHistoryData(Person p) {}

	protected void printHistoryData(Person p) {}
}