/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.person.Person;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class PurpleHeartHistoryTest extends AbstractHistoryTestCase {

	private static String personId = "71938";

	private static String historyDAOName = "purpleHeartHistoryDAO";

	protected void verifyRetrievedHistoryData(Person p) {
		assertNotNull("Person not found", p);
		assertNotNull("No decorations found", p.getDecorations());
	}

	protected void printHistoryData(Person p) {
		assertNotNull(p);
		printSet("Decorations", p.getDecorations());
	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getPersonId() {
		return personId;
	}
}