/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import java.math.BigDecimal;
import java.util.Set;

import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;

/**
 * @author DNS   CHENJ2
 *
 * Test purple heart registry history 
 **/
public class PHRegistryHistoryTest extends AbstractRegistryHistoryTest {
	private static String registryId = "20377599";

	private static String historyDAOName = "phRegistryHistoryDAO";


	protected void printHistoryData(Registry r) {
		super.printHistoryData(r);
		if (r != null) {
			PurpleHeart ph = (PurpleHeart) r;
			printSet("documents", ph.getDocuments());
		}
	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getRegistryId() {
		return registryId;
	}

	
	/*
	 * 
  SELECT p.person_id, p.purple_heart_registry_id, rt.REGISTRY_TRAIT_ID
  FROM purple_heart_registry p,
       ph_registry_detail phd,
       registry_trait rt,
       registry_trait_detail rtd
  WHERE phd.purple_heart_registry_id = p.purple_heart_registry_id
   AND p.registry_trait_id = rt.registry_trait_id
   AND rtd.registry_trait_id = rt.registry_trait_id
   
       71922            270262            270263
   
	 */
}