/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import java.util.Set;

import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class MilitaryServiceHistoryTest extends AbstractHistoryTestCase {

	private static String personId = "71964"; // "72943"

	private static String historyDAOName = "militaryServiceHistoryDAO";

	protected void verifyRetrievedHistoryData(Person p) {
		assertNotNull("Person not found", p);
		Set siteRecords = p.getMilitaryService().getMilitaryServiceSiteRecords();
		assertNotNull("SpecialFactors not found", p.getSpecialFactors());
		assertNotNull("MilitaryServiceSiteRecords not found", siteRecords);
	}

	protected void printHistoryData(Person p) {
		assertNotNull(p);
		printSet("SpecialFactors", p.getSpecialFactors());
		MilitaryService milService = p.getMilitaryService();
		if (milService != null) {
			printSet("MilitaryServiceSiteRecords", milService.getMilitaryServiceSiteRecords(),
					new String[] {"militaryServiceEpisodes", "conflictExperiences"});
		}
	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getPersonId() {
		return personId;
	}
}