/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import java.util.Set;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.FinancialsChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class FinancialsHistoryTest extends AbstractHistoryTestCase {

	protected HistoricalInfo executeDAOGetHistoryByChangeTime(ChangeEvent ce) throws DAOException {
		return ((FinancialsHistoryDAO)getHistoryDAO()).getHistoryByChangeTime((FinancialsChangeEvent)ce);
	}
	
	protected Set executeDAOGetHistoryChangeTimes(EntityKey personKey) throws DAOException {
		return ((FinancialsHistoryDAO)getHistoryDAO()).getHistoryChangeTimes(personKey, incomeYear);
	}

	private Integer incomeYear = new Integer(2005);

	private static String personId = "72184";

	private static String historyDAOName = "financialsHistoryDAO";

	protected void verifyRetrievedHistoryData(Person p) {
		assertNotNull("Person not found", p);
		assertNotNull("Beneficiary Travel not found", p.getBeneficiaryTravels(incomeYear));
		assertNotNull("FinancialStatement not found", p.getFinancialStatement(incomeYear));
		assertNotNull("IncomeTest not found", p.getIncomeTest(incomeYear));		
	}

	protected void printHistoryData(Person p) {
		assertNotNull(p);
		printSet("BeneficiaryTravel", p.getBeneficiaryTravels(incomeYear));
		printProperty("FinancialStatement", p.getFinancialStatement(incomeYear));
		IncomeTest incomeTest = p.getIncomeTest(incomeYear);
		printProperty("IncomeTest", incomeTest);
		if (incomeTest != null) {
			printSet("IncomeTestStatues", incomeTest.getStatuses());
		}
		
	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getPersonId() {
		return personId;
	}
	
	/**
	 * Subclass can override
	 * @return
	 */
	protected int getHistoryChangeTimeIndex()
	{
		return 7;  // 2005-10-06 13:22:52.0 income test has a delete (historyId=120)
	}

}