/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.history.AbstractHistoryTestCase;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class EnrollmentHistoryTest extends AbstractHistoryTestCase {

	private static String personId = "373971922";
	private static String historyDAOName = "enrollmentHistoryDAO";
		
	protected void verifyRetrievedHistoryData(Person p)
	{			
		assertNotNull(p);
	}

	protected void printHistoryData(Person p) {
		assertNotNull("Person not found", p);
		EnrollmentDetermination e= p.getEnrollmentDetermination();
		printProperty("EnrollmentDetermination", e);
		if (e != null) {
			printProperty("EGTSetting", e.getEgtSetting());
		}
		printProperty("CancelDecline", p.getCancelDecline());
		printProperty("EnrollmentOverride", p.getEnrollmentOverride());
		//printProperty("ReceivedEnrollment", p.getReceivedEnrollment());
		printProperty("application", p.getApplication());		
	}
	
	protected String getHistoryDAOName()
	{
		return historyDAOName;
	}
	
	protected String getPersonId()
	{
		return personId;
	}
}