/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.history.AbstractHistoryTestCase;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class EligibilityHistoryTest extends AbstractHistoryTestCase {

	private static String personId = "373971922";
	private static String historyDAOName = "eligibilityHistoryDAO";
		
	protected void verifyRetrievedHistoryData(Person p)
	{			
		assertNotNull("Person not found", p);
		assertNotNull("No enrollmentDetermination found", p.getEnrollmentDetermination());		
		/*assertNotNull("No primaryEligibility found", p.getEnrollmentDetermination().getPrimaryEligibility());
		assertNotNull("No secondaryEligibilities found", p.getEnrollmentDetermination().getSecondaryEligibilities());		
		assertNotNull("No otherEligibilities found", p.getEnrollmentDetermination().getOtherEligibilities());
		assertNotNull("No serviceConnectionAward found", p.getServiceConnectionAward());
		assertNotNull("No monetaryBenefitAward found", p.getMonetaryBenefitAward());
		assertNotNull("No eligibilityVerification found", p.getEligibilityVerification());
		assertNotNull("No prisonerOfWarRecords found", p.getPrisonerOfWarRecords());
		assertNotNull("No incompetenceRuling found", p.getIncompetenceRuling());
		assertNotNull("No decorations found", p.getDecorations());
		*/		
	}
	
	/* 
	 * @see gov.va.med.esr.common.persistent.history.AbstractHistoryTestCase#printHistoryData(gov.va.med.esr.common.model.person.Person)
	 */
	protected void printHistoryData(Person p) {
		assertNotNull(p);
		EnrollmentDetermination en = p.getEnrollmentDetermination();
		printProperty("enrollmentDetermination", en);
		if (en != null) {
			printProperty("primaryEligibility", en.getPrimaryEligibility());
			printSet("secondaryEligibilities", en.getSecondaryEligibilities());		
			printSet("otherEligibilities", en.getOtherEligibilities());
		}	
		ServiceConnectionAward scAward = p.getServiceConnectionAward();
		if (scAward!= null) {
			printProperty("serviceConnectionAward", p.getServiceConnectionAward());
			printSet("ratedDisability", scAward.getRatedDisabilities());
		}
		printProperty("monetaryBenefitAward", p.getMonetaryBenefitAward());
		printProperty("eligibilityVerification", p.getEligibilityVerification());
		PrisonerOfWar pow = p.getPrisonerOfWar();
		if (pow != null) {
			printProperty("serviceConnectionAward", p.getServiceConnectionAward());
			printSet("POWEpisodes", pow.getEpisodes());
		}
		printProperty("incompetenceRuling", p.getIncompetenceRuling());
		printSet("decorations", p.getDecorations());		
		printProperty("application", p.getApplication());		
		printProperty("ineligibility", p.getIneligibilityFactor());
		
	}
	
	protected String getHistoryDAOName()
	{
		return historyDAOName;
	}
	
	protected String getPersonId()
	{
		return personId;
	}
	
	protected int getHistoryChangeTimeIndex()
	{
		return 12;
	}

}