/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import java.math.BigDecimal;
import java.util.Set;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.persistent.DAOException;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class EGTHistoryTest extends AbstractHistoryTestCase {

	private static String historyDAOName = "egtHistoryDAO";

	protected void getHistoryChangeTimes() {
		try {
			Set results = executeDAOGetHistoryChangeTimes(null);
			assertNotNull("No dates returned", results);
			assertTrue("No dates returned", !(results.isEmpty()));
			log("Retrieved History timestamps: ");
			printChangeEvents(results);
			setRetrievedChangeEvents(results);
		} catch (Exception e) {
			fail("Can not execute DAO", e);
		}
	}

	protected void getHistoryByChangeTime(ChangeEvent ce) {
		try {
			log("\nRetrieving history for changeTime:" + ce.getTimeStamp());
			HistoricalInfo retrieved = executeDAOGetHistoryByChangeTime(ce);
			assertNotNull("No history object returned", retrieved);
		
			EGTHistorySet curr = (EGTHistorySet) retrieved.getCurrentVersion();			
			log("\n============ Retrieved current history objects: ============");
			verifyRetrievedHistoryData(curr);
			printHistoryData(curr);
			
			EGTHistorySet prev = (EGTHistorySet) retrieved.getPreviousVersion();
			log("\n============ Retrieved previous history objects: ============");
			verifyRetrievedHistoryData(prev);			
			printHistoryData(prev);
			
		} catch (Exception e) {
			fail("Can not execute DAO", e);
		}

	}
	
	protected void verifyRetrievedHistoryData(EGTHistorySet egtSet) {
		assertNotNull("egtSet", egtSet);
	}
	
	protected void printHistoryData(EGTHistorySet egtSet) {
		assertNotNull(egtSet);
		printSet("egtSet", egtSet.getEgts());
	}

	protected void verifyRetrievedHistoryData(Person p) {}

	protected void printHistoryData(Person p) {}
	
	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getPersonId() {
		return null;
	}
}