/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.FinancialsChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class DependentHistoryTest extends AbstractHistoryTestCase {

	protected HistoricalInfo executeDAOGetHistoryByChangeTime(ChangeEvent ce) throws DAOException {
		return ((FinancialsHistoryDAO)getHistoryDAO()).getHistoryByChangeTime((FinancialsChangeEvent)ce);
	}
	
	protected Set executeDAOGetHistoryChangeTimes(EntityKey personKey) throws DAOException {
		return ((FinancialsHistoryDAO)getHistoryDAO()).getHistoryChangeTimes(personKey, incomeYear);
	}

	private Integer incomeYear = new Integer(2005);

	private static String personId = "72822"; /* case for null previous data: "233671";*/ 
												//"20004844";//"106530";

	private static String historyDAOName = "dependentHistoryDAO";

	protected void verifyRetrievedHistoryData(Person p) {
		assertNotNull("Person not found", p);
		assertNotNull("FinancialStatement not found", p.getFinancialStatement(incomeYear));
	}

	protected void printHistoryData(Person p) {        
		assertNotNull(p);

		FinancialStatement fs = p.getFinancialStatement(incomeYear);
		if (fs != null) {
			Set spFins = fs.getSpouseFinancials();
			SpouseFinancials spFin = null;
			
			if (spFins != null) {
				for (Iterator iter = spFins.iterator(); iter.hasNext();) {
					spFin = (SpouseFinancials)iter.next();
					Spouse sp = spFin.getReportedOn();
					printProperty("Spouse", sp);
					if (sp!=null) {
						printSet("SSNs", sp.getSsns());
					}
				}
			}
			
			Set depFins = fs.getDependentFinancials();
			DependentFinancials depFin = null;
			Dependent dep = null;
			
			if (depFins != null) {
				for (Iterator iter = depFins.iterator(); iter.hasNext();) {
					depFin = (DependentFinancials)iter.next();
					dep = depFin.getReportedOn();
					printProperty("Dependent", dep);
					if (dep!=null) {
						printSet("SSNs", dep.getSsns());
					}
				}
			}
		}	
	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getPersonId() {
		return personId;
	}
}