/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.person.Person;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class DemographicHistoryTest extends AbstractHistoryTestCase {

	private static String personId = "73035";

	private static String historyDAOName = "demographicHistoryDAO";

	protected void verifyRetrievedHistoryData(Person p) {
		assertNotNull(p);
	}

	protected void printHistoryData(Person p) {
		assertNotNull("Person not found", p);
		log("Retrieved person.  id = " + 
				p.getEntityKey().getKeyValueAsString() + 
				"; historyId = " + p.getHistoryId() +
				"; VPID = " + p.getVPIDEntityKey().getKeyValueAsString() +
				"; ModifiedOn = " +	p.getModifiedOn());
		printSet("EmergencyResponseIndicators", p.getEmergencyResponseIndicators());

	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getPersonId() {
		return personId;
	}
	
}