/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class ClinicalDeterminationHistoryTest extends AbstractHistoryTestCase {

	private static String personId = "71982";

	private static String historyDAOName = "clinicalDeterminationHistoryDAO";

	protected void verifyRetrievedHistoryData(Person p) {
		assertNotNull("Person not found", p);
	}

	protected void printHistoryData(Person p) {
		assertNotNull(p);
		CatastrophicDisability cd = p.getCatastrophicDisability();
		printProperty("CD", cd);
		if (cd != null) {
			printSet("Conditions", cd.getConditions());
			printSet("Diagnosis", cd.getDiagnoses());
			printSet("Procedures", cd.getProcedures());
		}
		
		printProperty("MSTs", p.getMilitarySexualTrauma());
		printProperty("NTRs", p.getNoseThroatRadium());
	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getPersonId() {
		return personId;
	}
}