/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import java.math.BigDecimal;
import java.util.Set;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.persistent.DAOException;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class CapabilitySetHistoryTest extends AbstractHistoryTestCase {

	private static String historyDAOName = "capabilitySetHistoryDAO";

	private String capabilityId = "20380997";
	
	
	protected String getPersonId() {
		return capabilityId;
	}
	
	protected Class getRootObjectClass() {
		return CapabilitySet.class;
	}

	protected void getHistoryByChangeTime(ChangeEvent ce) {
		try {
			log("\nRetrieving history for changeTime:" + ce.getTimeStamp());
			HistoricalInfo retrieved = executeDAOGetHistoryByChangeTime(ce);
			assertNotNull("No history object returned", retrieved);
		
			CapabilitySet curr = (CapabilitySet) retrieved.getCurrentVersion();			
			log("\n============ Retrieved current history objects: ============");
			verifyRetrievedHistoryData(curr);
			printHistoryData(curr);
			
			CapabilitySet prev = (CapabilitySet) retrieved.getPreviousVersion();
			log("\n============ Retrieved previous history objects: ============");
			verifyRetrievedHistoryData(prev);			
			printHistoryData(prev);
			
		} catch (Exception e) {
			fail("Can not execute DAO", e);
		}

	}
	
	protected void verifyRetrievedHistoryData(CapabilitySet capabilitySet) {
		assertNotNull("capabilitySet", capabilitySet);
	}
	
	protected void printHistoryData(CapabilitySet capabilitySet) {
		assertNotNull(capabilitySet);
		printSet("capabilitySet", capabilitySet.getCapabilities());
	}
	
	protected String getHistoryDAOName() {
		return historyDAOName;
	}
	protected void verifyRetrievedHistoryData(Person p) {}

	protected void printHistoryData(Person p) {}
}