/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

//import java.sql.Timestamp;

import gov.va.med.esr.common.model.person.Person;
//import gov.va.med.esr.service.impl.ChangeEvent;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class AssociationHistoryTest extends AbstractHistoryTestCase {

	private static String personId = "72184";

	private static String historyDAOName = "associationHistoryDAO";

	protected void verifyRetrievedHistoryData(Person p) {
		assertNotNull("Person not found", p);
		assertNotNull("No associations found", p.getAssociations());
	}

	protected void printHistoryData(Person p) {
		if (p != null) {
			printSet("Associations", p.getAssociations());
		}
	}

	protected String getHistoryDAOName() {
		return historyDAOName;
	}

	protected String getPersonId() {
		return personId;
	}

	/*public void testGetHistoryForTimestamp() {
		// timestmp format: yyyy-mm-dd hh:mm:ss.fffffffff
		Timestamp ts = Timestamp.valueOf("2005-10-21 17:06:21");
        ChangeEvent ce = new ChangeEvent(ts, getPersonKey());
		getHistoryByChangeTime(ce);
	}*/
}