/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.history.AbstractHistoryTestCase;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Phone email address 
 **/
public class AddressHistoryTest extends AbstractHistoryTestCase {

	private static String personId = "72184";
	private static String historyDAOName = "addressHistoryDAO";
	
	protected void verifyRetrievedHistoryData(Person p)
	{			
		assertNotNull("Person not found", p);
		assertNotNull("No addresses found", p.getAddresses());
		assertNotNull("No phones found", p.getPhones());
		assertNotNull("No emails found", p.getEmails());
	}

	protected void printHistoryData(Person p) {
		assertNotNull(p);
		printSet("Addresses", p.getAddresses());
		printSet("Phones", p.getPhones());
		printSet("Emails", p.getEmails());
	}
	
	protected String getHistoryDAOName()
	{
		return historyDAOName;
	}
	
	protected String getPersonId()
	{
		return personId;
	}
}