/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;

import java.math.BigDecimal;

/**
 * @author DNS   CHENJ2
 *
 * Test history directly related to Registries
 **/
public abstract class AbstractRegistryHistoryTest extends AbstractHistoryTestCase {

	private EntityKey registryKey = null;

	protected void customSetUp() throws Exception {
		super.customSetUp();
		if (getRegistryId() != null) {
			registryKey = EntityKeyFactory.createEntityKey(new BigDecimal(getRegistryId()),
				Registry.class);
		}
	}

	protected void getHistoryChangeTimes() {
		try {
			setRetrievedChangeEvents(executeDAOGetHistoryChangeTimes(registryKey));
			assertNotNull("No dates returned", getRetrievedChangeEvents());
			assertTrue("No dates returned", !(getRetrievedChangeEvents().isEmpty()));
			log("Retrieved History timestamps: ");
			printChangeEvents(getRetrievedChangeEvents());
		} catch (Exception e) {
			fail("Can not execute DAO", e);
		}
	}

	protected void getHistoryByChangeTime(ChangeEvent ce) {
		try {
			log("\nRetrieving history for changeTime:" + ce.getTimeStamp());
			HistoricalInfo retrieved = executeDAOGetHistoryByChangeTime(ce);
			assertNotNull("No history object returned", retrieved);
			
			Registry currR = (Registry) retrieved.getCurrentVersion();
			Registry prevR = (Registry) retrieved.getPreviousVersion();
			
			verifyRetrievedHistoryData(currR);
			verifyRetrievedHistoryData(prevR);
			
			log("\n============ Retrieved current history objects: ============");
			printHistoryData(currR);
			log("\n============ Retrieved previous history objects: ============");
			printHistoryData(prevR);
			
		} catch (Exception e) {
			fail("Can not execute DAO", e);
		}

	}

	protected void verifyRetrievedHistoryData(Registry r) {
	}

	abstract protected String getRegistryId();

	
	protected void printHistoryData(Registry r) {
		if (r != null) {
			printProperty("Registry", r);
			RegistryTrait rt = r.getRegistryTrait();
			if (rt!=null) {
				printProperty("RegistryTrait", rt);
				if (rt.getRegistryTraitDetails() != null)
					printSet("RegistryTraitDetails", rt.getRegistryTraitDetails());
			}
		}
	}
	

	protected void printHistoryData(Person p) {
		// TODO Auto-generated method stub
		
	}

	protected void verifyRetrievedHistoryData(Person p) {
		// TODO Auto-generated method stub
		
	}

	protected String getPersonId() {
		// TODO Auto-generated method stub
		return null;
	}
}