/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate.mapping;

import java.math.BigDecimal;

import org.hibernate.Session;
import org.hibernate.SessionFactory;

import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.Decoration;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.ConsentAuthorization;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.InsurancePlan;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AffectedExtremity;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.CDDeterminationMethod;
import gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.Condition;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.common.model.lookup.DataSource;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.EGTSettingType;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.InsurancePlanType;
import gov.va.med.esr.common.model.lookup.InsuredRelationship;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.MilitarySexualTraumaStatus;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.NTRVerificationMethod;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;
import gov.va.med.esr.common.model.lookup.Procedure;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.Religion;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.VAFacilityType;
import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.util.AbstractCommonTestCase;

/**
 * @author Martin Francisco
 */
public class MappingTests
    extends AbstractCommonTestCase
{
    private SessionFactory sessionFactory;

    /**
     * @param name
     */
    public MappingTests(String name)
    {
        super(name);
    }
    
    protected void customSetUp() throws Exception
    {
        this.sessionFactory = (SessionFactory) applicationContext.getBean("sessionFactory");
    }


    public void testGetNoData() throws Exception
    {
        Session session = this.sessionFactory.openSession();
        Object obj = null;

        try
        {
            obj = session.get(AgentOrangeExposure.class, new BigDecimal("-100"));
            obj = session.get(Application.class, new BigDecimal("-100"));
            obj = session.get(CancelDecline.class, new BigDecimal("-100"));
            obj = session.get(CatastrophicDisability.class, new BigDecimal("-100"));
            obj = session.get(CDCondition.class, new BigDecimal("-100"));
            obj = session.get(CDDiagnosis.class, new BigDecimal("-100"));
            obj = session.get(CDProcedure.class, new BigDecimal("-100"));
            obj = session.get(ClinicalDetermination.class, new BigDecimal("-100"));
            obj = session.get(Decoration.class, new BigDecimal("-100"));
            obj = session.get(EGTSetting.class, new BigDecimal("-100"));
            obj = session.get(Eligibility.class, new BigDecimal("-100"));
            obj = session.get(EligibilityVerification.class, new BigDecimal("-100"));
            obj = session.get(EnrollmentDetermination.class, new BigDecimal("-100"));
            obj = session.get(EnvironmentalContaminationExposure.class, new BigDecimal(-100));
            obj = session.get(IncompetenceRuling.class, new BigDecimal("-100"));
            obj = session.get(IneligibilityFactor.class, new BigDecimal("-100"));
            obj = session.get(MilitarySexualTrauma.class, new BigDecimal("-100"));
            obj = session.get(MonetaryBenefit.class, new BigDecimal("-100"));
            obj = session.get(MonetaryBenefitAward.class, new BigDecimal("-100"));
            obj = session.get(NoseThroatRadium.class, new BigDecimal("-100"));
                obj = session.get(PurpleHeart.class, new BigDecimal("-100"));
            obj = session.get(RadiationExposure.class, new BigDecimal("-100"));
            obj = session.get(RatedDisability.class, new BigDecimal("-100"));
            obj = session.get(ReceivedEligibility.class, new BigDecimal("-100"));
            obj = session.get(ReceivedEnrollment.class, new BigDecimal("-100"));
            obj = session.get(ServiceConnectionAward.class, new BigDecimal("-100"));
            obj = session.get(SHAD.class, new BigDecimal("-100"));
            obj = session.get(SpecialFactor.class, new BigDecimal("-100"));
            obj = session.get(Asset.class, new BigDecimal("-100"));
            //obj = session.get(BeneficiaryTravel.class, new BigDecimal("-100"));
            obj = session.get(ConsentAuthorization.class, new BigDecimal("-100"));
            obj = session.get(Debt.class, new BigDecimal("-100"));
            obj = session.get(DependentFinancials.class, new BigDecimal("-100"));
            obj = session.get(Expense.class, new BigDecimal("-100"));
            obj = session.get(FinancialInformation.class, new BigDecimal("-100"));
            obj = session.get(FinancialStatement.class, new BigDecimal("-100"));
            //obj = session.get(Hardship.class, new BigDecimal("-100"));
            obj = session.get(Income.class, new BigDecimal("-100"));
            obj = session.get(IncomeTest.class, new BigDecimal("-100"));
            obj = session.get(IncomeTestStatus.class, new BigDecimal("-100"));
            obj = session.get(SpouseFinancials.class, new BigDecimal("-100"));
            obj = session.get(PatientVisitSummary.class, new BigDecimal("-100"));
            obj = session.get(InsurancePlan.class, new BigDecimal("-100"));
            obj = session.get(InsurancePolicy.class, new BigDecimal("-100"));
            obj = session.get(Medicare.class, new BigDecimal("-100"));
            obj = session.get(PrivateInsurance.class, new BigDecimal("-100"));
            obj = session.get(AACIndicator.class, new BigDecimal("-100"));
            obj = session.get(AddressChangeSource.class, new BigDecimal("-100"));
            obj = session.get(AddressType.class, new BigDecimal("-100"));
            obj = session.get(AffectedExtremity.class, new BigDecimal("-100"));
            obj = session.get(AgentOrangeExposureLocation.class, new BigDecimal("-100"));
            obj = session.get(AssetType.class, new BigDecimal("-100"));
            obj = session.get(AssociationType.class, new BigDecimal("-100"));
            obj = session.get(CDDeterminationMethod.class, new BigDecimal("-100"));
            obj = session.get(CancelDeclineNotProcessedReason.class, new BigDecimal("-100"));
            obj = session.get(CancelDeclineReason.class, new BigDecimal("-100"));
            obj = session.get(Condition.class, new BigDecimal("-100"));
            obj = session.get(ConflictLocation.class, new BigDecimal("-100"));
            obj = session.get(Country.class, new BigDecimal("-100"));
            obj = session.get(County.class, new BigDecimal("-100"));
            obj = session.get(DataSource.class, new BigDecimal("-100"));
            obj = session.get(DeathDataSource.class, new BigDecimal("-100"));
            obj = session.get(DecorationStatus.class, new BigDecimal("-100"));
            obj = session.get(Diagnosis.class, new BigDecimal("-100"));
            obj = session.get(Disability.class, new BigDecimal("-100"));
            obj = session.get(DischargeType.class, new BigDecimal("-100"));
            obj = session.get(EGTSettingType.class, new BigDecimal("-100"));
            obj = session.get(EmailType.class, new BigDecimal("-100"));
            obj = session.get(EligibilityType.class, new BigDecimal("-100"));
            obj = session.get(EligibilityVerificationSource.class, new BigDecimal("-100"));
            obj = session.get(EmploymentStatus.class, new BigDecimal("-100"));
            obj = session.get(EnrollmentCategory.class, new BigDecimal("-100"));
            obj = session.get(EnrollmentPriorityGroup.class, new BigDecimal("-100"));
            obj = session.get(EnrollmentPrioritySubGroup.class, new BigDecimal("-100"));
            obj = session.get(EnrollmentSource.class, new BigDecimal("-100"));
            obj = session.get(EnrollmentStatus.class, new BigDecimal("-100"));
            obj = session.get(ExpenseType.class, new BigDecimal("-100"));
            obj = session.get(FilipinoVeteranProof.class, new BigDecimal("-100"));
            obj = session.get(Gender.class, new BigDecimal("-100"));
            obj = session.get(IncomeTestSource.class, new BigDecimal("-100"));
            obj = session.get(IncomeTestType.class, new BigDecimal("-100"));
            obj = session.get(IncomeType.class, new BigDecimal("-100"));
            obj = session.get(InsurancePlanType.class, new BigDecimal("-100"));
            obj = session.get(InsuredRelationship.class, new BigDecimal("-100"));
            obj = session.get(MaritalStatus.class, new BigDecimal("-100"));
            obj = session.get(MeansTestStatus.class, new BigDecimal("-100"));
            obj = session.get(MessageStatus.class, new BigDecimal("-100"));
            obj = session.get(MessageType.class, new BigDecimal("-100"));
            obj = session.get(MilitarySexualTraumaStatus.class, new BigDecimal("-100"));
            obj = session.get(MonetaryBenefitType.class, new BigDecimal("-100"));
            obj = session.get(NameType.class, new BigDecimal("-100"));
            obj = session.get(PhoneType.class, new BigDecimal("-100"));
            obj = session.get(PrisonerOfWarLocation.class, new BigDecimal("-100"));
            obj = session.get(Procedure.class, new BigDecimal("-100"));
            obj = session.get(RadiationExposureMethod.class, new BigDecimal("-100"));
            obj = session.get(RejectionRemark.class, new BigDecimal("-100"));
            obj = session.get(Relationship.class, new BigDecimal("-100"));
            obj = session.get(Religion.class, new BigDecimal("-100"));
            obj = session.get(ServiceBranch.class, new BigDecimal("-100"));
            obj = session.get(ServicePeriod.class, new BigDecimal("-100"));
            obj = session.get(State.class, new BigDecimal("-100"));
            obj = session.get(VAFacilityType.class, new BigDecimal("-100"));
            obj = session.get(NTRVerificationMethod.class, new BigDecimal("-100"));
            obj = session.get(ZipCode.class, new BigDecimal("-100"));
            obj = session.get(MessageLogEntry.class, new BigDecimal("-100"));
            obj = session.get(SiteIdentity.class, new BigDecimal("-100"));
            obj = session.get(Address.class, new BigDecimal("-100"));
            obj = session.get(Email.class, new BigDecimal("-100"));
             obj = session.get(Phone.class, new BigDecimal("-100"));
            obj = session.get(Association.class, new BigDecimal("-100"));
            obj = session.get(Dependent.class, new BigDecimal("-100"));
            obj = session.get(Name.class, new BigDecimal("-100"));
            obj = session.get(Person.class, new BigDecimal("-100"));
            obj = session.get(Spouse.class, new BigDecimal("-100"));
        }
        finally
        {
            try
            {
                session.close();
            }
            catch(Exception e)
            {
            }
        }
    }

    /*public void testSavePersonWithPrincipal() throws Exception
    {
        UserPrincipalImpl principal = new UserPrincipalImpl(new BigDecimal("9991"), "Joe");
        
        HashSet set = new HashSet();
        set.add(principal);
        Subject subject = new Subject(true, set, new HashSet(), new HashSet());
        
        Subject.doAs(subject, new PrivilegedAction() {
            public Object run()
            {
                doSavePersonWithPrincipal();
                return null;
            }
        });
    }
    
    private void doSavePersonWithPrincipal()
    {
        try
        {
            Session session = this.sessionFactory.openSession(new AuditInterceptor());
            Person person = new Person();
            person.setSsn("123456789");
            session.saveOrUpdate(person);
            session.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException(e);
        }
    }*/

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.util.MappingTestCase#getMappings()
     */
    /*protected String[] getMappings()
    {
        return new String[] {
                "shared/hibernate/gov/vha/edb/common/model/ee/Application.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/ee/EGTSetting.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/ee/Eligibility.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/ee/EnrollmentDetermination.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/ee/ProcessState.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/ee/RatedDisability.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/ee/ServiceConnectionAward.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/AACIndicator.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/AddressType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/AffectedExtremity.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/AgentOrangeExposureLocation.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/AssetType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/AssociationType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/CDDeterminationMethod.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/CancelDeclineNotProcessedReason.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/CancelDeclineReason.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/Condition.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/Conflict.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/Country.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/County.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/DataSource.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/DecorationStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/Diagnosis.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/Disability.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/DischargeType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/EmailType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/EligibilityStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/EligibilityType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/EmploymentStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/EnrollmentCategory.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/EnrollmentPriorityGroup.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/EnrollmentPrioritySubGroup.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/EnrollmentStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/ExpenseType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/Gender.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/IncomeType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/InsurancePlanType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/MaritalStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/MessageStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/MessageType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/MilitaryRetirementStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/MilitarySexualTraumaStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/MonetaryBenefitType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/NameType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/PhoneType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/PrisonerOfWarLocation.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/Procedure.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/ProcessStatusType.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/RadiationExposureMethod.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/ReceivedEligibilityStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/Relationship.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/ServiceBranch.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/State.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/VerificationStatus.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/lookup/ZipCode.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/messaging/MessageLogEntry.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/messaging/SiteIdentity.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/party/Party.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/party/Role.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/party/Organization.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/party/VAFacility.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/person/Beneficiary.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/person/Name.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/person/Person.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/principal/Principal.hbm.xml",
                "shared/hibernate/gov/vha/edb/common/model/principal/UserPrincipal.hbm.xml" };
    }*/
}