/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

// Java classes

// Library classes

// Framework classes
import java.util.Iterator;
import java.util.List;

import gov.va.med.fw.model.AbstractKeyedEntity;

// ESR classes
import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.esr.service.LookupService;

/**
 * This class is a JUnit that tests Special Factors.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ZipCodeTest extends AbstractKeyedEntityDAOTestCase
{
    public static final String GAITHERSBURG_ZIP_CODE = "20879";

    protected DAOTestMode[] setUpTests()
    {
        return new DAOTestMode[]{TEST_QUERY};
    }

    public void testNamedQueries()
    {
        try
        {
            LookupService lookupService = getLookupService();

            // Single "full" zip code lookup
            ZipCode zipCode = lookupService.getZipCodeByCode(GAITHERSBURG_ZIP_CODE);
            System.out.println("Full zip code details for " + GAITHERSBURG_ZIP_CODE + ": " + zipCode);

            // Single "partial" zip code lookup
            zipCode = lookupService.getPartialZipCodeByCode(GAITHERSBURG_ZIP_CODE);
            System.out.println("Partial zip code details for " + GAITHERSBURG_ZIP_CODE + ": " + zipCode);

/*
            // Full zip code list (this will take a very long time)
            List zipCodeList2 = lookupService.getAllZipCodes();
            for (Iterator iterator = zipCodeList2.iterator(); iterator.hasNext();)
            {
                ZipCode zipCode = (ZipCode)iterator.next();
                System.out.println(zipCode.getZipCode() + ": " + zipCode.getFormattedZipLocation());
            }
*/
        }
        catch (Exception e)
        {
            fail("Problem in testNamedQueries method", e);
        }
    }

    public void testZipCodeByCityState() {
        try
        {
            LookupService lookupService = getLookupService();

            List zipCodeList = lookupService.getPartialZipCodeByCityState("Herndon", "VA");
            for (Iterator iter = zipCodeList.iterator(); iter.hasNext();) {
				ZipCode zipCode = (ZipCode) iter.next();
	            System.out.println("Partial zip code details for Herndon, VA: " + zipCode);
			}
        }
        catch (Exception e)
        {
            fail("Problem in testZipCodeByCityState method", e);
        }
    }
    
    public void testZipCodeByCity() {
        try
        {
            LookupService lookupService = getLookupService();

            List zipCodeList = lookupService.getPartialZipCodeByCity("Reston");
            System.out.println(" There are "+zipCodeList.size()+" zip codes for this city.");
            for (Iterator iter = zipCodeList.iterator(); iter.hasNext();) {
				ZipCode zipCode = (ZipCode) iter.next();
	            System.out.println("Partial zip code details for Reston: " + zipCode);
			}
        }
        catch (Exception e)
        {
            fail("Problem in testZipCodeByCity method", e);
        }
    }
    
    /**
     * (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj)
    {
        // No updating necessary
    }

    /**
     * (non-Javadoc)
     *
     * @see AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception
    {
        // No setup needed
        return null;
    }
}