/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.esr.common.model.ee.VoaFileAttachmentDetail;
import gov.va.med.esr.common.model.ee.VoaFileAttachmentImage;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AuthenticationLevel;
import gov.va.med.esr.common.model.lookup.BenefitType;
import gov.va.med.esr.common.model.lookup.EligibilityDocType;
import gov.va.med.esr.common.model.lookup.EthnicityType;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.RaceType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.SpinalCordInjuryType;
import gov.va.med.esr.common.model.lookup.VOAApplicationStatus;
import gov.va.med.esr.common.model.lookup.VOAFormType;
import gov.va.med.esr.common.model.lookup.VeteranIdentifierType;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.common.model.person.VOAApplicationData;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.math.BigDecimal;
import java.util.Date;

public class VOAApplicationTest
    extends AbstractKeyedEntityDAOTestCase {
    
	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
	 */
	protected AbstractKeyedEntity setUpTestObject() throws Exception {
		VOAApplication voaApplication = buildVOAApplication();
		return voaApplication;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
		VOAApplication app = (VOAApplication)obj;
		app.setFirstName("Greg");
	}

	private VOAApplication buildVOAApplication() throws Exception {
		VOAApplication voaApp = new VOAApplication();
		voaApp.addFileAttachment(createFileAttachment());
		voaApp.setVOAApplicationData(createApplicationData());
		voaApp.setApplicationStatus(getLookupService().getVOAApplicationStatusByCode(VOAApplicationStatus.FORM_PROCESSING_IN_PROGRESS.getCode()));
		voaApp.setAuthenticationLevel(getLookupService().getAuthenticationLevelByCode(AuthenticationLevel.DS_LOGON_LEVEL_1.getCode()));
		voaApp.setFirstName("Larry");
		voaApp.setFormType(getLookupService().getVOAFormTypeByCode(VOAFormType.VOA_FORM_1010EZ.getCode()));
		voaApp.setFullQualifiedId("1234567");
		voaApp.setLastName("Thornfire");
		voaApp.setPersonId(new BigDecimal("375333923"));
		voaApp.setSsn("472819326");
		voaApp.setGender(getLookupService().getGenderByCode(Gender.FEMALE.getCode()));
		voaApp.setDateOfBirth(new Date());
		voaApp.setIdentityType(getLookupService().getVeteranIdentifierTypeByCode(VeteranIdentifierType.CODE_VPID.getCode()));
		
		return voaApp;
	}

	private VOAApplicationData createApplicationData() {
		VOAApplicationData data = new VOAApplicationData();
		data.setApplicationData("applicationData");
		return data;
	}

	private VoaFileAttachment createFileAttachment() throws Exception {
		VoaFileAttachment attachment = new VoaFileAttachment();
		attachment.addVoaAttachmentDetail(createAttachmentDetail());
		attachment.setAttachmentImage(createAttachmentImage());
		attachment.setAttachmentReviewDate(new Date());
		attachment.setAttachmentReviewUserName("esr");
		attachment.setAttchmentAcceptableInd(Boolean.TRUE);
		attachment.setFileMimeType("PDF");
		attachment.setFileName("attachment123.PDF");
		attachment.setPersonId(new BigDecimal("375333923"));

		return attachment;
	}

	private VoaFileAttachmentImage createAttachmentImage() {
		VoaFileAttachmentImage image = new VoaFileAttachmentImage();
		image.setFileImage(new byte[]{1,0,2});
		return image;
	}

	private VoaFileAttachmentDetail createAttachmentDetail() throws Exception {
		VoaFileAttachmentDetail detail = new VoaFileAttachmentDetail();
		detail.setEligibilityDocType(getLookupService().getEligibilityDocTypeByCode(EligibilityDocType.DD_214.getCode()));
		return detail;
	}
	
	protected QueryInfo[] getNamedQueries() {
		String[] paramNames = new String[] { "personId" };
		Object[] params = new Object[] { new BigDecimal("375333923") };
		QueryInfo query1 = new QueryInfo("VOAApplication_GetByPersonId", paramNames, params);
		
		paramNames = new String[] { "applicationId" };
		params = new Object[] { new BigDecimal( "375344029" ) };
		QueryInfo query2 = new QueryInfo("VOA_BY_APPLICATION_ID_QUERY", paramNames, params);
	
		return new QueryInfo[] { query1, query2};
	}	

	protected Person buildPerson() throws Exception {
        Person p = super.buildPerson();
        
 //       p.setVOA(Boolean.TRUE);
        p.setReligion(getLookupService().getReligionByCode("ABC"));
       //  employment with employer address & phone
        p.setEmployment(createEmployment());
        p.addRace(createRace());
        p.setEthnicity(createEthnicity());
        p.setMother(createRelationWName(Relationship.CODE_MOTHER.getCode()));
        p.setFather(createRelationWName(Relationship.CODE_FATHER.getCode()));
        
        // application benefitType
        Application appl = p.getApplication();
        if (appl != null) {
            appl.setBenefitType(getLookupService().getBenefitTypeByCode(BenefitType.CODE_DENTAL.getCode()));
        }
        
        // spouse address & phone
        Spouse spouse = this.createSpouse();
        spouse.setAddress(createAddress(getLookupService().getAddressTypeByCode(AddressType.CODE_PRIMARY_RESIDENCE.getCode())));
        //phone
        spouse.setHomePhone(createPhone(getLookupService().getPhoneTypeByCode(PhoneType.CODE_HOME.getCode())));
        // spouse employment
        spouse.setEmployment(createEmployment());
              
        // spinal cord injury
        attachSpinalCordInjury(p);
         
        // PSIM: place of birth city; state, indicator
        BirthRecord br = p.getBirthRecord();
        br.setCity("Denver");
        br.setState("CO");
        br.setMultipleBirth(Boolean.TRUE);     
 
        return p;
    }
    
    protected Race createRace() throws Exception {
        Race race = new Race();
        race.setRaceType(getLookupService().getRaceTypeByCode(RaceType.CODE_ASIAN.getCode()));
        race.setCollectionMethod(getLookupService().getCollectionMethodByCode("SLF"));
        return race;
    }

    protected Ethnicity createEthnicity() throws Exception {
        Ethnicity ethnicity = new Ethnicity();
        ethnicity.setEthnicityType(getLookupService().getEthnicityTypeByCode(EthnicityType.CODE_HISPANIC.getCode()));
        ethnicity.setCollectionMethod(getLookupService().getCollectionMethodByCode("SLF"));
        return ethnicity;
    }
    
    protected Relation createRelationWName(String relationshipCode) throws Exception {
        Relation relation = new Relation();
        relation.setRelationship(getLookupService().getRelationshipByCode(relationshipCode));
        relation.setName(createName());
        return relation;
    }

    protected void attachSpinalCordInjury(Person person) throws Exception {
        SpinalCordInjury spinal =  new SpinalCordInjury();
        spinal.setSpinalCordInjuryType(getLookupService().getSpinalCordInjuryTypeByCode(SpinalCordInjuryType.CODE_PARAPLEGIA_TRAUMATIC.getCode()));
        person.addClinicalDetermination(spinal);
    }

    protected Employment createEmployment() throws Exception {
        Employment employment = new Employment();
       employment.setEmployerAddress(createSimpleAddress(getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode())));
        employment.setEmployerName("BigIndustries");
        employment.setEmployerPhone("999-899-4500");
        employment.setEmploymentStatus(getLookupService().getEmploymentStatusByCode("5"/*retired*/));
        employment.setOccupation("BottlePacker");
        employment.setRetirementDate(new ImpreciseDate(new Date()));
        return employment;
    }
	
}