/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Oct 21, 2005
 *
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.Pension;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.lookup.PensionReasonCode;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.util.DataSetupTestCase;

import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;

import java.util.Date;
import java.util.Set;

/**
 * @author George Tsai
 * @version 1.0
 */
public class VBADataTest extends DataSetupTestCase {
    
    public VBADataTest(String name) {
        super(name);
        super.setDefaultRollback(false);
    }
    
    public void setUpData() throws Exception {        
     }
    
    public void tearDownData() throws Exception {
    }    
 
    public void testSaveNewPension() throws Exception {

    	try{
	    	String vpid = "0000000000000258V930235000000";
	        Person person = personDao.getByVPID(CommonEntityKeyFactory.createVPIDEntityKey(vpid));
	
			MonetaryBenefitAward awd = person.getMonetaryBenefitAward();
			if ( awd == null)
			{
				awd = new MonetaryBenefitAward();
				awd.setPerson(person);
				person.setMonetaryBenefitAward(awd);
			}
			
			MonetaryBenefit ben = awd.getVAPension();
			if ( ben == null)
			{
				ben = new  MonetaryBenefit();
				ben.setMonetaryBenefitAward(awd);
				ben.setType((MonetaryBenefitType)this.getLookupService().getByCode(MonetaryBenefitType.class, MonetaryBenefitType.CODE_VA_PENSION.getCode()));
				
				awd.addMonetaryBenefit(ben);
			}
			
			
			Pension p = ben.getPension();
			if (p == null)
			{
				p = new Pension();
				p.setMonetaryBenefit(ben);
	    		p.setTerminationDate(new Date());
	    		p.setTerminationReasonCode1((PensionReasonCode)getLookupService().getByCode(PensionReasonCode.class, "AT"));
	    		p.setTerminationReasonCode2((PensionReasonCode)getLookupService().getByCode(PensionReasonCode.class, "37"));
	    		p.setTerminationReasonCode3((PensionReasonCode)getLookupService().getByCode(PensionReasonCode.class, "DB"));
	    		p.setTerminationReasonCode4((PensionReasonCode)getLookupService().getByCode(PensionReasonCode.class, "4"));
	    		
	    		ben.setPension(p);
			}        
			
			personDao.saveObject(p);
    	} catch (Exception e)
    	{
    		//examine the exception e
    		System.out.println(e.getMessage());
    	}
    }
    
    public void testGetPensionByVPID() throws Exception {

    	String vpid = "0000000000000258V930235000000";
        Person p = personDao.getByVPID(CommonEntityKeyFactory.createVPIDEntityKey(vpid));

        MonetaryBenefitAward award = p.getMonetaryBenefitAward();
        MonetaryBenefit benefit = award.getMonetaryBenefitByType(MonetaryBenefitType.CODE_VA_PENSION);
        Pension pension = benefit.getPension();
        
        assertEquals(pension.getTerminationReasonCode1().getCode(), "AT");
        assertEquals(pension.getTerminationReasonCode2().getCode(), "37");
        assertEquals(pension.getTerminationReasonCode3().getCode(), "DB");
        assertEquals(pension.getTerminationReasonCode4().getCode(), "4");
        
    }
    
    public void testSaveNewDental() throws Exception
    {
    	String vpid = "0000000000000258V930235000000";
        Person p = personDao.getByVPID(CommonEntityKeyFactory.createVPIDEntityKey(vpid));
        
        p.setEligibleForClassIIDental(Boolean.TRUE);
        p.setClassIIDentalApplicationDueBefore(new Date(1000000000));
        personDao.saveObject(p);
    }

    public void testGetDentalByVPID() throws Exception {
    	
    	String vpid = "0000000000000258V930235000000";
        Person p = personDao.getByVPID(CommonEntityKeyFactory.createVPIDEntityKey(vpid));
        
        assertEquals(Boolean.TRUE, p.getEligibleForClassIIDental());
        assertEquals(new Date(1000000000), p.getClassIIDentalApplicationDueBefore());
    }
    public void testUpdatePension() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();

/* 	        BeneficiaryTravel t = p.getBeneficiaryTravel(this.year, this.vaFacility);
     	    if(t==null) {
        		p.setBeneficiaryTravel(this.year,this.vaFacility,this.beneTravel);        		
           		personDao.saveObject(p);
           		t = ((Person) personDao.getByKey(p.getEntityKey())).getBeneficiaryTravel(this.year, this.vaFacility);
     	    }
     	    
     	    if (t!=null) {
     	        t.setClaimDate(new Date());
    		    personDao.saveObject(p);     		    
     		    return;                
            }*/
  	        fail("Did not update bene travel");
     	}
     	catch(Exception ex) {
     		fail("Failed to update bene travel", ex);
     	}
     }
    
/*    public void testAddGetBeneTravel() throws Exception {
       
    	try {
    	    
    	   	// insert a phone
	        Person p = getPerson();	        
    		p.setBeneficiaryTravel(this.year,this.vaFacility,this.beneTravel);        		
       		personDao.saveObject(p);
       		BeneficiaryTravel t = ((Person) personDao.getByKey(p.getEntityKey())).getBeneficiaryTravel(this.year, this.vaFacility);
       		assertNotNull(t);
 	    }
    	catch(Exception ex) {
    		fail("Failed to get phone", ex);
    	}
    }*/
   
}

