package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Tests the StateDAO getByName
 * 
 * @author Rajiv Patnaik
 * Created on Nov 3, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class StateTest extends AbstractKeyedEntityDAOTestCase
{
    private static final String VALID_STATE_NAME = "New York";
    private static final String INVALID_STATE_NAME = "New York blah blah";
    private static final String CASE_SENSITIVE_STATE_NAME = "New YoRK";

    protected DAOTestMode[] setUpTests()
    {
        return new DAOTestMode[]{TEST_QUERY};
    }

    public void testNamedQueries()
    {
        try
        {
            LookupService lookupService = getLookupService();

            // Single "full" zip code lookup
            State state = lookupService.getStateByName(VALID_STATE_NAME);
            assertNotNull("State is null", state);
            System.out.println("State details for " + VALID_STATE_NAME + ": " + state);
            
            state = lookupService.getStateByName(INVALID_STATE_NAME);
            assertNull("State is not null", state);
            
            state = lookupService.getStateByName(CASE_SENSITIVE_STATE_NAME);
            assertNotNull("State is null", state);
            
        }catch (Exception e) {
            fail("Did not pass testNamedQueries ", e);
        }
    }
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception
    {
        // TODO Auto-generated method stub

    }

}
