/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

// Java classes
import java.util.Iterator;
import java.util.Set;
import java.util.List;
import java.util.ArrayList;

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// ESR classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;

/**
 * This class is a JUnit that tests Special Factors.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class SpecialFactorTest extends AbstractKeyedEntityDAOTestCase
{
    /**
     * (non-Javadoc)
     *
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception
    {
        // Build a person
        Person person = buildSimplePerson();
        person.setClaimFolderNumber("JDCFN");

        // Add Vietnam Agent Orange Exposure
        AgentOrangeExposure agentOrangeExposure = new AgentOrangeExposure();
        agentOrangeExposure.setLocation(getLookupService().getAgentOrangeExposureLocationByCode(
            AgentOrangeExposureLocation.CODE_VIETNAM.getName()));
        person.addSpecialFactor(agentOrangeExposure);

        // Add Environment Contamination Exposure
        EnvironmentalContaminationExposure ece = new EnvironmentalContaminationExposure();
        person.addSpecialFactor(ece);

        // Add Nuclear Testing Radiation Exposure
        person.addSpecialFactor(createRadiationExposure());
        RadiationExposure radiationExposure = new RadiationExposure();
        radiationExposure.setExposureMethod(getLookupService().getRadiationExposureMethodByCode(
            RadiationExposureMethod.CODE_NAGASAKI_HIROSHIMA.getName()));
        person.addSpecialFactor(radiationExposure);

        return person;
    }

    /**
     * (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj)
    {
        try
        {
            List removeSpecialFactorsList = new ArrayList();
            Person person = (Person)obj;
            Set specialFactors = person.getSpecialFactors();
            for (Iterator iterator = specialFactors.iterator(); iterator.hasNext();)
            {
                SpecialFactor specialFactor = (SpecialFactor)iterator.next();
                if (specialFactor instanceof AgentOrangeExposure)
                {
                    // Modify Agent Orange Exposure to Korean DMZ
                    AgentOrangeExposure agentOrangeExposure = (AgentOrangeExposure)specialFactor;
                    agentOrangeExposure.setLocation(getLookupService().getAgentOrangeExposureLocationByCode(
                        AgentOrangeExposureLocation.CODE_KOREAN_DMZ.getName()));
                }
                else
                {
                    // Add to the list of special factors to remove
                    if (specialFactor instanceof EnvironmentalContaminationExposure)
                    {
                        removeSpecialFactorsList.add(specialFactor);
                    }
                }
            }

            // Remove special factors
            for (Iterator removeIterator = removeSpecialFactorsList.iterator(); removeIterator.hasNext();)
            {
                SpecialFactor specialFactor = (SpecialFactor)removeIterator.next();
                person.removeSpecialFactor(specialFactor);
            }

            // Add Shipping Hazzard
            //person.addSpecialFactor(new SHAD());
        }
        catch (Exception ex)
        {
            throw new RuntimeException("Error in modifyTestObject.", ex);
        }
    }
}