/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 19, 2006
 *
 */
package gov.va.med.esr.common.persistent.hibernate;





// Java classes
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

// Library classes

// Framework classes


// EDB Classes
import gov.va.med.esr.common.model.lookup.SignatureIndicator;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.util.DataSetupTestCase;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;

/**
 * @author Yi He
 * @version 1.0
 */
public class SignatureImageTest extends DataSetupTestCase {
    private SignatureImage signatureImage = null;
    
    public SignatureImageTest(String name) {
        super(name);
        super.setDefaultRollback(false);
    }
    
    public void setUpData() throws Exception {
        signatureImage = new SignatureImage();
		signatureImage.setDateIndex(new Date());
		signatureImage.setImageIdNumber("123");
		signatureImage.setIncomeYear(new Integer(2005));
		signatureImage.setUser("superuser");
		SignatureIndicator indicator = (SignatureIndicator) getLookupService().getByCode(SignatureIndicator.class, "1");
	    signatureImage.setSignatureIndicator(indicator);
	    VAFacility vaFacility = getLookupService().getVaFacilityByCode("552");
        signatureImage.setSiteSubmittingImage(vaFacility);
    }
    
     
    public void tearDownData() throws Exception {
    	signatureImage = null;
    }        
 
    public void testUpdateSignatureImage() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();
     	    Set signatureImages = p.getSignatureImages();
     	    if(signatureImages.isEmpty()) {
        		p.addSignatureImage(signatureImage);        		
           		personDao.saveObject(p);
           		signatureImages = ((Person) personDao.getByKey(p.getEntityKey())).getSignatureImages();
     	    }
     	    
     	    Iterator iter = signatureImages.iterator();
     	    if (iter.hasNext()) {
                SignatureImage ph = (SignatureImage) iter.next();
                ph.setImageIdNumber(String.valueOf(new Date().getTime()));
        		personDao.saveObject(p);     		    
     		    return;                
            }
  	        fail("Did not update signatureImage");
     	}
     	catch(Exception ex) {
     		fail("Failed to get signatureImage", ex);
     	}
     }
    


    public void testAddGetSignatureImage() throws Exception {
       
    	try {
    	    
    
    	   	// insert a signatureImage
	        Person p = getPerson();
	        p.addSignatureImage(signatureImage);
	   	
    	   	// save signatureImage with person
	     	personDao.saveObject(p);
	  	   	
    	    // refresh data from database 
    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
    	    Set signatureImages = retrievedPerson.getSignatureImages();
    	    Iterator iter = signatureImages.iterator();
    	    while (iter.hasNext()) {
    	        SignatureImage sm = (SignatureImage)iter.next();
    		    if(signatureImage.getImageIdNumber().equals(sm.getImageIdNumber())) {
    		        logger.info("Got signatureImage = " + sm);
    		        System.out.println("Got signatureImage = " + sm);
    		        return;
    		    } 
            }
            fail("Could not find SignatureImage ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get signatureImage", ex);
    	}
    }

    public void testRemoveAllSignatureImages() throws Exception {
        Person p = getPerson(); // p already has a signatureImage
        p.addSignatureImage(signatureImage);

        p.removeAllSignatureImages();
        
	   	// save signatureImage with person
     	personDao.saveObject(p);
  	   	
	    // refresh data from database 
	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
        
        assertEquals(retrievedPerson.getSignatureImages().size(),0);
    } 
}

