/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public class ServiceConnectionAwardTest
    extends AbstractKeyedEntityDAOTestCase {

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
		person.setServiceConnectionAward(createServiceConnectionAward());
        return person;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person) obj;
        ServiceConnectionAward serviceConnectionAward = person.getServiceConnectionAward();
        Set disabilities = serviceConnectionAward.getRatedDisabilities();
        for (Iterator iter = disabilities.iterator(); iter.hasNext();) {
            RatedDisability ratedDisability = (RatedDisability) iter.next();
            ratedDisability.setRatingDate(new ImpreciseDate(new Date()));
        }
        serviceConnectionAward.removeRatedDisability((RatedDisability) disabilities.iterator().next());
    }
    
    protected ServiceConnectionAward createServiceConnectionAward() throws Exception {
		ServiceConnectionAward serviceConnectionAward = new ServiceConnectionAward();
		serviceConnectionAward.setServiceConnectedPercentage(new Integer(60));
		serviceConnectionAward.setCombinedServiceConnectedPercentageEffectiveDate(new ImpreciseDate(new Date()));
		serviceConnectionAward.setUnemployable(Boolean.FALSE);
		//serviceConnectionAward.setPermanentAndTotal(Boolean.FALSE);
		serviceConnectionAward.addRatedDisability(this.createRatedDisability());
		serviceConnectionAward.addRatedDisability(this.createRatedDisability());
		return serviceConnectionAward;
        
    }
}