package gov.va.med.esr.common.persistent.hibernate;

import java.math.BigDecimal;
import java.util.Calendar;

import gov.va.med.esr.common.model.person.SSNVerification;
import gov.va.med.esr.common.model.person.SSNVerificationDetail;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Tests the persistence for SSNVerification and SSNVerificationDetail 
 *  
 * @author Rajiv Patnaik Created on Mar 8, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SSNVerificationTestCase extends AbstractKeyedEntityDAOTestCase
{
   
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception
    {
        SSNVerification ssnVerification = new SSNVerification();
        ssnVerification.setCountSentToSsa(new Integer(150));
        ssnVerification.setCountTotal(new Integer(250));
        ssnVerification.setSsaSentDate(Calendar.getInstance().getTime());

        SSNVerificationDetail ssnVerificationDetail = new SSNVerificationDetail();
        ssnVerificationDetail.setHECInternalId("221212322");
        ssnVerificationDetail.setPersonId(new BigDecimal(72091));
        ssnVerificationDetail.setSsnId(new BigDecimal(67208));
        ssnVerificationDetail.setSsnText("123456679");

        ssnVerification.addSSNVerificationDetail(ssnVerificationDetail);

        return ssnVerification;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception
    {
        SSNVerification ssnVerification = (SSNVerification) obj;
        ssnVerification.setCountTotal(new Integer(900));

        SSNVerificationDetail ssnVerificationDetail = (SSNVerificationDetail) ssnVerification
                .getSSNVerificationDetails().iterator().next();
        ssnVerificationDetail.setSsnText("67567788");

    }

}