/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Apr 3, 2006
 *
 */
package gov.va.med.esr.common.persistent.hibernate;

// Java classes
import java.math.BigDecimal;
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.report.ReportExportedType;

// EDB Classes
import java.util.List;

import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.common.persistent.report.ReportDAO;
import gov.va.med.esr.common.persistent.security.SecurityDAO;
import gov.va.med.esr.common.model.lookup.DayOfMonth;
import gov.va.med.esr.common.model.lookup.DayOfQuarter;
import gov.va.med.esr.common.model.lookup.DayOfWeek;
import gov.va.med.esr.common.model.lookup.Month;
import gov.va.med.esr.common.model.lookup.Quarter;
import gov.va.med.esr.common.model.lookup.ReportDetailBy;
import gov.va.med.esr.common.model.lookup.ReportDetailFor;
import gov.va.med.esr.common.model.lookup.ReportDivision;
import gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType;
import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.ReportLetterFile;
import gov.va.med.esr.common.model.lookup.ReportPeriodType;
import gov.va.med.esr.common.model.lookup.ReportRunFrequency;
import gov.va.med.esr.common.model.lookup.ReportScheduleType;
import gov.va.med.esr.common.model.lookup.ReportType;
import gov.va.med.esr.common.model.lookup.ReportWorkItemStatus;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.lookup.WeekOfMonth;
import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportSetupLite;
import gov.va.med.esr.common.model.report.SimpleCompletedReport;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.security.UserPrincipal;
import java.util.Iterator;
/**
 * @author Yi He
 * @version 1.0
 */
public class ReportDAOTest extends AbstractCommonTestCase {
    
	ReportDAO reportDAO;
	SecurityDAO securityDAO;
	
	public ReportDAOTest(String testName) {
		super(testName);
        super.setDefaultRollback(false);
	}

	public ReportDAO getReportDAO(){
		return this.reportDAO;
	}
	
	public void setReportDAO(ReportDAO dao) {
		this.reportDAO = dao;
	}
	
	public SecurityDAO getSecurityDAO(){
		return this.securityDAO;
	}
	
	public void setSecurityDAO (SecurityDAO dao) {
		this.securityDAO = dao;
	}
	
	
	public void	testGetReportSetupsWithUser() throws DAOException {
		UserPrincipal user = securityDAO.findUserByUsername("esr");
		long start = new Date().getTime();
	    List l = reportDAO.getReportSetups(user);
	    long end = new Date().getTime();
		System.out.println("before get all reports = " + start);
		System.out.println("after get all reports = " + end);
		Iterator iter = l.iterator();
		System.out.println("schedule count="+l.size());
		while(iter.hasNext()) {
			Object obj = iter.next();
			System.out.println("clazz="+obj.getClass().getName());
			ReportSetupLite rs = (ReportSetupLite) obj ;
			System.out.println("report user="+rs.getSetupUser().getEntityKey().getKeyValueAsString());
//			System.out.println("report type="+rs.getFileType());
//			System.out.println("report standard="+rs.getReport());
			
			
//			System.out.println("standard report="+rs.getReport());
		}
	    this.assertNotNull(l);
	    this.assertTrue(!l.isEmpty());
	}

	public void	testGetReportSetupsWithEntityKey() throws DAOException {
		EntityKey key = EntityKeyFactory.createEntityKey(new BigDecimal(65487120),ReportSetup.class);
	    ReportSetup rs = reportDAO.getReportSetup(key);
	    this.assertNotNull(rs);
	}
	
	public void	testUpdateReportSetup() throws DAOException {
		EntityKey key = EntityKeyFactory.createEntityKey(new BigDecimal(2323234),ReportSetup.class);
	    ReportSetup rs = reportDAO.getReportSetup(key);
	    rs.getSchedule().setDateToGenerate(new Date());
	    rs.getParameterSet().setFromDate(new Date());
	    reportDAO.saveReportSetup(rs);
	}
		
	public void	testReportLookups() throws Exception {
		LookupService lookupService = getLookupService();
		
		Class[] lookups = new Class[] {
				DayOfMonth.class,
				DayOfQuarter.class,
				DayOfWeek.class,
				Month.class,
				Quarter.class,
				ReportDetailBy.class,
				ReportDetailFor.class,
				ReportDivision.class,
				ReportEEDWeeklyType.class,
				ReportExceptionType.class,
				ReportFacilityDisplayBy.class,
				ReportFormat.class,
				ReportLetterFile.class,
				ReportPeriodType.class,
				ReportScheduleType.class,
				ReportType.class,
				ReportWorkItemStatus.class,
				WeekOfMonth.class,
				ReportExportedType.class,
				ReportRunFrequency.class
				};
		
		String code = null;
		Class cls = null;
		
		for(int i=0; i<lookups.length; i++) {
			cls = lookups[i];
			if (cls == ReportExportedType.class)
				code = "PDF";
			else
				code = "1";
			
			lookupService.getByCode(cls, code);
			lookupService.findAll(cls);
		}
		
		lookupService.getAllStandardReports();
		lookupService.getStandardReportByCode("EED 5");	
	}
	
	public void	testGetCompletedReportWithEntityKey() throws DAOException {
		EntityKey key = EntityKeyFactory.createEntityKey(new BigDecimal(523671),CompletedReport.class);
	    CompletedReport report = reportDAO.getCompletedReport(key);
	    assertNotNull(report);
	    assertNotNull(report.getReportFileContent());
    	System.out.println("file content " + new String(report.getReportFileContent()));
	}
	
	public void testAddCompletedReport() throws Exception {
		CompletedReport report = new CompletedReport();
		report.setCompletedDate(new Date());
		report.setStandardReport(getLookupService().getStandardReportByCode("EED 5"));
        report.setUser((ESRUserPrincipal)securityDAO.findUserByUsername("bea"));
    //    report.setSetup(reportDAO.getReportSetup(EntityKeyFactory.createEntityKey(new BigDecimal(65487120),ReportSetup.class)));
       report.setFileType(getLookupService().getReportExportedTypeByCode("1"));
        report.setReportFileContent("abc".getBytes());
        reportDAO.saveCompletedReport(report);
	}
	
	public void	testGetCompletedReportsWithUser() throws DAOException {
		UserPrincipal user = securityDAO.findUserByUsername("esr");
		long start = new Date().getTime();
	    List l = reportDAO.getCompletedReports(user);
	    long end = new Date().getTime();
		System.out.println("before get all reports = " + start);
		System.out.println("after get all reports = " + end);
		Iterator iter = l.iterator();
		System.out.println("schedule count="+l.size());
		while(iter.hasNext()) {
			Object obj = iter.next();
			System.out.println("clazz="+obj.getClass().getName());
			SimpleCompletedReport r = (SimpleCompletedReport) obj ;
			System.out.println("r"+r.getCompletedDate());
			System.out.println("r"+r.getStandardReport());
			System.out.println("r"+r.getFileType());
		}	    
	    this.assertNotNull(l);
	    this.assertTrue(!l.isEmpty());
	}
	
}

