/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.person.Person;

/**
 * 
 * @author DNS   MANSOG
 * @date Aug 15, 2005 6:01:10 PM
 * @version 1.0
 */
public class ReceivedEnrollmentTest extends AbstractKeyedEntityDAOTestCase {

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        ReceivedEnrollment re = createReceivedEnrollment();
        person.setReceivedEnrollment(re);
        return person;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person)obj;
        ReceivedEnrollment re = person.getReceivedEnrollment();
        re.setRemarks("Test Remarks");
        re.setOverridden(Boolean.TRUE);
    }

}